/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.community.model.zhipu.AuthorizationUtils;
import dev.langchain4j.community.model.zhipu.InternalZhipuAiHelper;
import dev.langchain4j.community.model.zhipu.Json;
import dev.langchain4j.community.model.zhipu.ZhipuAiException;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.zhipu.chat.ToolCall;
import dev.langchain4j.community.model.zhipu.embedding.EmbeddingRequest;
import dev.langchain4j.community.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.community.model.zhipu.image.ImageRequest;
import dev.langchain4j.community.model.zhipu.image.ImageResponse;
import dev.langchain4j.community.model.zhipu.shared.ErrorResponse;
import dev.langchain4j.community.model.zhipu.shared.Usage;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZhipuAiClient {
    private static final Logger log = LoggerFactory.getLogger(ZhipuAiClient.class);
    private final Boolean logResponses;
    private final String apiKey;
    private final String baseUrl;
    private final HttpClient httpClient;

    ZhipuAiClient(Builder builder) {
        this.logResponses = builder.logResponses;
        this.apiKey = builder.apiKey;
        this.baseUrl = builder.baseUrl;
        HttpClientBuilder httpClientBuilder = HttpClientBuilderLoader.loadHttpClientBuilder();
        HttpClient client = httpClientBuilder.readTimeout(builder.readTimeout).connectTimeout(builder.connectTimeout).build();
        this.httpClient = builder.logRequests || builder.logResponses ? new LoggingHttpClient(client, Boolean.valueOf(builder.logRequests), Boolean.valueOf(builder.logResponses)) : client;
    }

    static Builder builder() {
        return new Builder();
    }

    ChatCompletionResponse chatCompletion(ChatCompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().url(this.baseUrl, "api/paas/v4/chat/completions").method(HttpMethod.POST).addHeader("Content-Type", new String[]{"application/json"}).addHeader("Authorization", new String[]{AuthorizationUtils.getToken(this.apiKey)}).body(Json.toJson(request)).build();
        try {
            SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
            return Json.fromJson(successfulHttpResponse.body(), ChatCompletionResponse.class);
        }
        catch (HttpException e) {
            throw InternalZhipuAiHelper.toZhipuAiException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    EmbeddingResponse embedAll(EmbeddingRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().url(this.baseUrl, "api/paas/v4/embeddings").method(HttpMethod.POST).addHeader("Content-Type", new String[]{"application/json"}).addHeader("Authorization", new String[]{AuthorizationUtils.getToken(this.apiKey)}).body(Json.toJson(request)).build();
        try {
            SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
            return Json.fromJson(successfulHttpResponse.body(), EmbeddingResponse.class);
        }
        catch (HttpException e) {
            this.logHttpException(e);
            throw new RuntimeException(e);
        }
    }

    private void logHttpException(HttpException e) {
        int statusCode = e.statusCode();
        String errorBodyString = e.getMessage();
        String errorMessage = String.format("status code: %s; body: %s", statusCode, errorBodyString);
        log.error("Error response: {}", (Object)errorMessage);
    }

    void streamingChatCompletion(ChatCompletionRequest request, final StreamingChatResponseHandler handler) {
        HttpRequest httpRequest = HttpRequest.builder().url(this.baseUrl, "api/paas/v4/chat/completions").method(HttpMethod.POST).addHeader("Content-Type", new String[]{"application/json"}).addHeader("Authorization", new String[]{AuthorizationUtils.getToken(this.apiKey)}).body(Json.toJson(request)).build();
        ServerSentEventListener eventListener = new ServerSentEventListener(){
            final StringBuffer contentBuilder = new StringBuffer();
            List<ToolExecutionRequest> specifications;
            TokenUsage tokenUsage;
            FinishReason finishReason;
            ChatCompletionResponse chatCompletionResponse;
            String modelName = null;
            String id = null;

            public void onEvent(ServerSentEvent event) {
                String data = event.data();
                if ("[DONE]".equals(data)) {
                    AiMessage aiMessage = Utils.isNullOrEmpty(this.specifications) ? AiMessage.from((String)this.contentBuilder.toString()) : AiMessage.from(this.specifications);
                    ChatResponse response = ChatResponse.builder().aiMessage(aiMessage).tokenUsage(this.tokenUsage).finishReason(this.finishReason).id(this.id).modelName(this.modelName).build();
                    handler.onCompleteResponse(response);
                } else {
                    try {
                        List<ToolCall> toolCalls;
                        String finishReasonString;
                        Usage zhipuUsageInfo;
                        this.chatCompletionResponse = Json.fromJson(data, ChatCompletionResponse.class);
                        ChatCompletionChoice zhipuChatCompletionChoice = this.chatCompletionResponse.getChoices().get(0);
                        String chunk = zhipuChatCompletionChoice.getDelta().getContent();
                        this.contentBuilder.append(chunk);
                        handler.onPartialResponse(chunk);
                        if (Utils.isNotNullOrBlank((String)this.chatCompletionResponse.getId())) {
                            this.id = this.chatCompletionResponse.getId();
                        }
                        if (Utils.isNotNullOrBlank((String)this.chatCompletionResponse.getModel())) {
                            this.modelName = this.chatCompletionResponse.getModel();
                        }
                        if ((zhipuUsageInfo = this.chatCompletionResponse.getUsage()) != null) {
                            this.tokenUsage = InternalZhipuAiHelper.tokenUsageFrom(zhipuUsageInfo);
                        }
                        if ((finishReasonString = zhipuChatCompletionChoice.getFinishReason()) != null) {
                            this.finishReason = InternalZhipuAiHelper.finishReasonFrom(finishReasonString);
                        }
                        if (!Utils.isNullOrEmpty(toolCalls = zhipuChatCompletionChoice.getDelta().getToolCalls())) {
                            this.specifications = InternalZhipuAiHelper.specificationsFrom(toolCalls);
                        }
                    }
                    catch (Exception exception) {
                        ZhipuAiClient.this.handleResponseException(exception, handler);
                    }
                }
            }

            public void onError(Throwable t) {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onError()", t);
                }
                ZhipuAiClient.this.handleResponseException(t, handler);
            }

            public void onClose() {
                if (ZhipuAiClient.this.logResponses.booleanValue()) {
                    log.debug("onClosed()");
                }
            }
        };
        this.httpClient.execute(httpRequest, eventListener);
    }

    private void handleResponseException(Throwable t, StreamingChatResponseHandler handler) {
        Object throwable;
        if (t instanceof HttpException) {
            HttpException httpException = (HttpException)t;
            if (Utils.isNullOrBlank((String)httpException.getMessage())) {
                throwable = new ZhipuAiException(String.valueOf(httpException.statusCode()), null);
            } else {
                try {
                    ErrorResponse errorResponse = Json.fromJson(httpException.getMessage(), ErrorResponse.class);
                    throwable = (Throwable)Utils.getOrDefault((Object)((Object)new ZhipuAiException(errorResponse.getError().get("code"), errorResponse.getError().get("message"))), (Object)t);
                }
                catch (Exception ignored) {
                    throwable = new ZhipuAiException(String.valueOf(httpException.statusCode()), null);
                }
            }
        } else {
            throwable = t;
        }
        handler.onError(throwable);
    }

    ImageResponse imagesGeneration(ImageRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().url(this.baseUrl, "api/paas/v4/images/generations").method(HttpMethod.POST).addHeader("Content-Type", new String[]{"application/json"}).addHeader("Authorization", new String[]{AuthorizationUtils.getToken(this.apiKey)}).body(Json.toJson(request)).build();
        try {
            SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
            return Json.fromJson(successfulHttpResponse.body(), ImageResponse.class);
        }
        catch (HttpException e) {
            this.logHttpException(e);
            throw new RuntimeException(e);
        }
    }

    static class Builder {
        private String baseUrl = "https://open.bigmodel.cn/";
        private String apiKey;
        private Duration callTimeout = Duration.ofSeconds(60L);
        private Duration connectTimeout = Duration.ofSeconds(60L);
        private Duration readTimeout = Duration.ofSeconds(60L);
        private Duration writeTimeout = Duration.ofSeconds(60L);
        private boolean logRequests;
        private boolean logResponses;

        private Builder() {
        }

        Builder baseUrl(String baseUrl) {
            if (baseUrl != null && !baseUrl.trim().isEmpty()) {
                this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
                return this;
            }
            throw new IllegalArgumentException("baseUrl cannot be null or empty");
        }

        Builder apiKey(String apiKey) {
            if (apiKey != null && !apiKey.trim().isEmpty()) {
                this.apiKey = apiKey;
                return this;
            }
            throw new IllegalArgumentException("apiKey cannot be null or empty. ");
        }

        Builder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        Builder logRequests() {
            return this.logRequests(true);
        }

        Builder logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses() {
            return this.logResponses(true);
        }

        Builder logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return this;
        }

        ZhipuAiClient build() {
            return new ZhipuAiClient(this);
        }
    }
}

