/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.community.model.zhipu.chat.Parameters;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Function {
    private String name;
    private String description;
    private Parameters parameters;

    private Function(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Parameters parameters() {
        return this.parameters;
    }

    public static final class Builder {
        private String name;
        private String description;
        private Parameters parameters;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder addParameter(String name, Map<String, JsonSchemaElement> properties) {
            this.addOptionalParameter(name, properties);
            this.parameters.getRequired().add(name);
            return this;
        }

        public Builder addOptionalParameter(String name, Map<String, JsonSchemaElement> properties) {
            if (this.parameters == null) {
                this.parameters = Parameters.builder().build();
            }
            HashMap<String, JsonSchemaElement> jsonSchemaPropertiesMap = new HashMap<String, JsonSchemaElement>();
            for (Map.Entry<String, JsonSchemaElement> entry : properties.entrySet()) {
                jsonSchemaPropertiesMap.put(entry.getKey(), entry.getValue());
            }
            this.parameters.getProperties().put(name, jsonSchemaPropertiesMap);
            return this;
        }

        public Function build() {
            return new Function(this);
        }
    }
}

