/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.community.model.zhipu.chat.Message;
import dev.langchain4j.community.model.zhipu.chat.Role;
import dev.langchain4j.internal.Utils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class SystemMessage
implements Message {
    private Role role;
    private String content;
    private String name;

    public SystemMessage(Role role, String content, String name) {
        this.role = (Role)((Object)Utils.getOrDefault((Object)((Object)role), (Object)((Object)Role.SYSTEM)));
        this.content = content;
        this.name = name;
    }

    public static SystemMessage from(String content) {
        return SystemMessage.builder().content(content).build();
    }

    public static SystemMessageBuilder builder() {
        return new SystemMessageBuilder();
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class SystemMessageBuilder {
        private Role role;
        private String content;
        private String name;

        SystemMessageBuilder() {
        }

        public SystemMessageBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public SystemMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SystemMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SystemMessage build() {
            return new SystemMessage(this.role, this.content, this.name);
        }
    }
}

