/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.zhipu.Json;
import dev.langchain4j.community.model.zhipu.ZhipuAiException;
import dev.langchain4j.community.model.zhipu.chat.AssistantMessage;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionChoice;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.zhipu.chat.Content;
import dev.langchain4j.community.model.zhipu.chat.Function;
import dev.langchain4j.community.model.zhipu.chat.FunctionCall;
import dev.langchain4j.community.model.zhipu.chat.Image;
import dev.langchain4j.community.model.zhipu.chat.ImageContent;
import dev.langchain4j.community.model.zhipu.chat.Message;
import dev.langchain4j.community.model.zhipu.chat.Parameters;
import dev.langchain4j.community.model.zhipu.chat.SystemMessage;
import dev.langchain4j.community.model.zhipu.chat.TextContent;
import dev.langchain4j.community.model.zhipu.chat.Tool;
import dev.langchain4j.community.model.zhipu.chat.ToolCall;
import dev.langchain4j.community.model.zhipu.chat.ToolMessage;
import dev.langchain4j.community.model.zhipu.chat.ToolType;
import dev.langchain4j.community.model.zhipu.chat.UserMessage;
import dev.langchain4j.community.model.zhipu.embedding.EmbeddingResponse;
import dev.langchain4j.community.model.zhipu.shared.ErrorResponse;
import dev.langchain4j.community.model.zhipu.shared.Usage;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
class InternalZhipuAiHelper {
    private static final String FINISH_REASON_SENSITIVE = "sensitive";
    private static final String FINISH_REASON_OTHER = "other";

    InternalZhipuAiHelper() {
    }

    static List<Embedding> toEmbed(List<EmbeddingResponse> response) {
        return response.stream().map(zhipuAiEmbedding -> Embedding.from(zhipuAiEmbedding.getEmbedding())).collect(Collectors.toList());
    }

    static List<Tool> toTools(List<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(toolSpecification -> Tool.from(InternalZhipuAiHelper.toFunction(toolSpecification))).collect(Collectors.toList());
    }

    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalZhipuAiHelper.toFunctionParameters(toolSpecification)).build();
    }

    private static Parameters toFunctionParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            JsonObjectSchema parameters = toolSpecification.parameters();
            return Parameters.builder().properties(JsonSchemaElementUtils.toMap((Map)parameters.properties())).required(parameters.required()).build();
        }
        return Parameters.builder().build();
    }

    static List<Message> toZhipuAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalZhipuAiHelper::toZhipuAiMessage).collect(Collectors.toList());
    }

    private static Message toZhipuAiMessage(ChatMessage message) {
        if (message instanceof dev.langchain4j.data.message.SystemMessage) {
            dev.langchain4j.data.message.SystemMessage systemMessage = (dev.langchain4j.data.message.SystemMessage)message;
            return SystemMessage.builder().content(systemMessage.text()).build();
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            if (userMessage.hasSingleText()) {
                return UserMessage.from(userMessage.singleText());
            }
            ArrayList<Content> contents = new ArrayList<Content>(userMessage.contents().size());
            userMessage.contents().forEach(content -> {
                if (content instanceof dev.langchain4j.data.message.TextContent) {
                    dev.langchain4j.data.message.TextContent textContent = (dev.langchain4j.data.message.TextContent)content;
                    contents.add(TextContent.builder().text(textContent.text()).build());
                }
                if (content instanceof dev.langchain4j.data.message.ImageContent) {
                    dev.langchain4j.data.image.Image image = ((dev.langchain4j.data.message.ImageContent)content).image();
                    contents.add(ImageContent.builder().imageUrl(Image.builder().url(image.url() != null ? image.url().toString() : image.base64Data()).build()).build());
                }
            });
            return UserMessage.from(contents);
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.builder().content(aiMessage.text()).build();
            }
            ArrayList<ToolCall> toolCallArrayList = new ArrayList<ToolCall>();
            for (ToolExecutionRequest executionRequest : aiMessage.toolExecutionRequests()) {
                toolCallArrayList.add(ToolCall.builder().function(FunctionCall.builder().name(executionRequest.name()).arguments(executionRequest.arguments()).build()).type(ToolType.FUNCTION).id(executionRequest.id()).build());
            }
            return AssistantMessage.builder().content(aiMessage.text()).toolCalls(toolCallArrayList).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage resultMessage = (ToolExecutionResultMessage)message;
            return ToolMessage.builder().content(resultMessage.text()).build();
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(message.type())), (Object[])new Object[0]);
    }

    static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        AssistantMessage message = response.getChoices().get(0).getMessage();
        if (Utils.isNullOrEmpty(message.getToolCalls())) {
            return AiMessage.from((String)message.getContent());
        }
        return AiMessage.from(InternalZhipuAiHelper.specificationsFrom(message.getToolCalls()));
    }

    static List<ToolExecutionRequest> specificationsFrom(List<ToolCall> toolCalls) {
        ArrayList<ToolExecutionRequest> specifications = new ArrayList<ToolExecutionRequest>(toolCalls.size());
        for (ToolCall toolCall : toolCalls) {
            specifications.add(ToolExecutionRequest.builder().id(toolCall.getId()).name(toolCall.getFunction().getName()).arguments(toolCall.getFunction().getArguments()).build());
        }
        return specifications;
    }

    static Usage getEmbeddingUsage(List<EmbeddingResponse> responses) {
        Usage tokenUsage = Usage.builder().completionTokens(0).promptTokens(0).totalTokens(0).build();
        for (EmbeddingResponse response : responses) {
            tokenUsage.add(response.getUsage());
        }
        return tokenUsage;
    }

    static TokenUsage tokenUsageFrom(Usage zhipuUsage) {
        if (zhipuUsage == null) {
            return null;
        }
        return new TokenUsage(zhipuUsage.getPromptTokens(), zhipuUsage.getCompletionTokens(), zhipuUsage.getTotalTokens());
    }

    static ChatCompletionResponse toChatErrorResponse(Throwable throwable) {
        return ChatCompletionResponse.builder().choices(Collections.singletonList(InternalZhipuAiHelper.toChatErrorChoice(throwable))).usage(Usage.builder().build()).build();
    }

    private static ChatCompletionChoice toChatErrorChoice(Throwable throwable) {
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            String message = httpException.getMessage();
            if (Utils.isNullOrBlank((String)message)) {
                return ChatCompletionChoice.builder().finishReason(FINISH_REASON_OTHER).build();
            }
            ErrorResponse errorResponse = Json.fromJson(message, ErrorResponse.class);
            String code = errorResponse.getError().get("code");
            return ChatCompletionChoice.builder().message(AssistantMessage.builder().content(errorResponse.getError().get("message")).build()).finishReason(InternalZhipuAiHelper.getFinishReason(code)).build();
        }
        return ChatCompletionChoice.builder().message(AssistantMessage.builder().content(throwable.getMessage()).build()).finishReason(FINISH_REASON_OTHER).build();
    }

    public static ZhipuAiException toZhipuAiException(HttpException httpException) {
        String message = httpException.getMessage();
        if (Utils.isNullOrBlank((String)message)) {
            return new ZhipuAiException(httpException.getMessage());
        }
        ErrorResponse errorResponse = Json.fromJson(message, ErrorResponse.class);
        String code = errorResponse.getError().get("code");
        String errorMessage = errorResponse.getError().get("message");
        return new ZhipuAiException(code, errorMessage);
    }

    static String getFinishReason(Object o) {
        ZhipuAiException exception;
        if (o instanceof String && "1301".equals(o)) {
            return FINISH_REASON_SENSITIVE;
        }
        if (o instanceof ZhipuAiException && "1301".equals((exception = (ZhipuAiException)((Object)o)).getCode())) {
            return FINISH_REASON_SENSITIVE;
        }
        return FINISH_REASON_OTHER;
    }

    static boolean isSuccessFinishReason(FinishReason finishReason) {
        return !FinishReason.CONTENT_FILTER.equals((Object)finishReason) && !FinishReason.OTHER.equals((Object)finishReason);
    }

    static FinishReason finishReasonFrom(String finishReason) {
        if (finishReason == null) {
            return null;
        }
        return switch (finishReason) {
            case "stop" -> FinishReason.STOP;
            case "length" -> FinishReason.LENGTH;
            case "tool_calls" -> FinishReason.TOOL_EXECUTION;
            case FINISH_REASON_SENSITIVE -> FinishReason.CONTENT_FILTER;
            default -> FinishReason.OTHER;
        };
    }
}

