/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.model.output.structured.Description;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ToolSpecificationsTest
implements WithAssertions {
    ToolSpecificationsTest() {
    }

    @Test
    public void test_removeNulls() {
        this.assertThat(ToolSpecifications.removeNulls((JsonSchemaProperty[])new JsonSchemaProperty[]{null, JsonSchemaProperty.STRING, null})).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.STRING});
    }

    private static Method getF() throws NoSuchMethodException {
        return Wrapper.class.getMethod("f", String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, String[].class, Integer[].class, Boolean[].class, int[].class, boolean[].class, List.class, Set.class, Collection.class, List.class, Set.class, Collection.class, E.class, Person.class, Integer.TYPE, Integer.TYPE);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    @Test
    public void test_toolSpecificationsFrom() {
        List specs = ToolSpecifications.toolSpecificationsFrom((Object)new Wrapper());
        this.assertThat(specs).hasSize(2);
        this.assertThat(specs).extracting(ToolSpecification::name).containsExactlyInAnyOrder((Object[])new String[]{"f", "func_name"});
    }

    @Test
    public void test_toolSpecificationsFrom_with_duplicate_method_names() {
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ToolSpecifications.toolSpecificationsFrom((Object)new InvalidToolsWithDuplicateMethodNames())).withMessage("Tool names must be unique. The tool 'duplicateMethod' appears several times").withNoCause();
    }

    @Test
    public void test_toolSpecificationsFrom_with_duplicate_names() {
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ToolSpecifications.toolSpecificationsFrom((Object)new InvalidToolsWithDuplicateNames())).withMessage("Tool names must be unique. The tool 'duplicate_name' appears several times").withNoCause();
    }

    @Test
    public void test_toolName_memoryId() throws NoSuchMethodException {
        Method method = Wrapper.class.getMethod("g", String.class);
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("func_name");
        this.assertThat(ts.description()).isEmpty();
        this.assertThat(ts.parameters()).isNull();
    }

    @Test
    public void test_toolSpecificationFrom() throws NoSuchMethodException {
        Method method = ToolSpecificationsTest.getF();
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("f");
        this.assertThat(ts.description()).isEqualTo("line1\nline2");
        this.assertThat(ts.parameters().type()).isEqualTo("object");
        Map properties = ts.parameters().properties();
        this.assertThat(properties).hasSize(32);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)this.assertThat(properties).containsEntry((Object)"arg0", ToolSpecificationsTest.mapOf("type", "string", "description", "foo"))).containsEntry((Object)"arg1", ToolSpecificationsTest.mapOf("type", "boolean"))).containsEntry((Object)"arg2", ToolSpecificationsTest.mapOf("type", "boolean", "description", "b2"))).containsEntry((Object)"arg3", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg4", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg5", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg6", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg7", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg8", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg9", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg10", ToolSpecificationsTest.mapOf("type", "integer"))).containsEntry((Object)"arg11", ToolSpecificationsTest.mapOf("type", "integer", "description", "biggy"))).containsEntry((Object)"arg12", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg13", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg14", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg15", ToolSpecificationsTest.mapOf("type", "number"))).containsEntry((Object)"arg16", ToolSpecificationsTest.mapOf("type", "number", "description", "bigger"))).containsEntry((Object)"arg17", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")))).containsEntry((Object)"arg18", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg19", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "boolean")))).containsEntry((Object)"arg20", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg21", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "boolean")))).containsEntry((Object)"arg22", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "integer")))).containsEntry((Object)"arg23", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "number")))).containsEntry((Object)"arg24", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")))).containsEntry((Object)"arg25", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg26", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg27", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object")))).containsEntry((Object)"arg29", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("name", ToolSpecificationsTest.mapOf("description", "Name of the person", "type", "string"), "active", ToolSpecificationsTest.mapOf("type", "boolean"), "aliases", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")), "currentAddress", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("city", ToolSpecificationsTest.mapOf("type", "string"), "street", ToolSpecificationsTest.mapOf("type", "string"))), "parent", ToolSpecificationsTest.mapOf("type", "object"), "aliases", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")), "previousAddresses", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("city", ToolSpecificationsTest.mapOf("type", "string"), "street", ToolSpecificationsTest.mapOf("type", "string")))))))).containsEntry((Object)"arg30", ToolSpecificationsTest.mapOf("type", "integer", "description", "optional"))).containsEntry((Object)"arg31", ToolSpecificationsTest.mapOf("type", "integer", "description", "required"));
        this.assertThat((Map)properties.get("arg28")).containsEntry((Object)"type", (Object)"string");
        this.assertThat(((Map)properties.get("arg28")).get("enum")).isEqualTo(Arrays.asList("A", "B", "C"));
        this.assertThat(ts.parameters().required()).containsExactly((Object[])new String[]{"arg0", "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7", "arg8", "arg9", "arg10", "arg11", "arg12", "arg13", "arg14", "arg15", "arg16", "arg17", "arg18", "arg19", "arg20", "arg21", "arg22", "arg23", "arg24", "arg25", "arg26", "arg27", "arg28", "arg29", "arg31"});
    }

    @Test
    public void test_toJsonSchemaProperties() throws NoSuchMethodException {
        Method method = ToolSpecificationsTest.getF();
        Parameter[] ps = method.getParameters();
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[0])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.STRING, JsonSchemaProperty.description((String)"foo")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[1])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.BOOLEAN});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[2])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.BOOLEAN, JsonSchemaProperty.description((String)"b2")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[3])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[4])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[5])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[6])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[7])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[8])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[9])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[10])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[11])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER, JsonSchemaProperty.description((String)"biggy")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[12])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[13])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[14])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[15])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[16])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.NUMBER, JsonSchemaProperty.description((String)"bigger")});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[17])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.STRING)});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[18])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.INTEGER)});
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[19])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.ARRAY, JsonSchemaProperty.items((JsonSchemaProperty)JsonSchemaProperty.BOOLEAN)});
        ArrayList properties = new ArrayList();
        ToolSpecifications.toJsonSchemaProperties((Parameter)ps[28]).forEach(properties::add);
        this.assertThat((JsonSchemaProperty)properties.get(0)).isEqualTo((Object)JsonSchemaProperty.STRING);
        this.assertThat(((JsonSchemaProperty)properties.get(1)).value()).isEqualTo(Arrays.asList("A", "B", "C"));
        this.assertThat(ToolSpecifications.toJsonSchemaProperties((Parameter)ps[29])).containsExactly((Object[])new JsonSchemaProperty[]{JsonSchemaProperty.OBJECT, JsonSchemaProperty.from((String)"properties", ToolSpecificationsTest.mapOf("name", ToolSpecificationsTest.mapOf("description", "Name of the person", "type", "string"), "active", ToolSpecificationsTest.mapOf("type", "boolean"), "aliases", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")), "currentAddress", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("city", ToolSpecificationsTest.mapOf("type", "string"), "street", ToolSpecificationsTest.mapOf("type", "string"))), "parent", ToolSpecificationsTest.mapOf("type", "object"), "aliases", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "string")), "previousAddresses", ToolSpecificationsTest.mapOf("type", "array", "items", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("city", ToolSpecificationsTest.mapOf("type", "string"), "street", ToolSpecificationsTest.mapOf("type", "string"))))))});
    }

    @Test
    void test_object_used_multiple_times() {
        List toolSpecifications = ToolSpecifications.toolSpecificationsFrom(CustomerRegistration.class);
        this.assertThat(toolSpecifications).hasSize(1);
        this.assertThat(((ToolSpecification)toolSpecifications.get(0)).name()).isEqualTo("registerCustomer");
        this.assertThat(((ToolSpecification)toolSpecifications.get(0)).description()).isEqualTo("register a new customer");
        this.assertThat(((ToolSpecification)toolSpecifications.get(0)).parameters().type()).isEqualTo("object");
        Map.Entry orderParameter = ((ToolSpecification)toolSpecifications.get(0)).parameters().properties().entrySet().iterator().next();
        Map properties = (Map)((Map)orderParameter.getValue()).get("properties");
        this.assertThat(properties).hasSize(3);
        this.assertThat(properties).containsEntry((Object)"name", ToolSpecificationsTest.mapOf("type", "string"));
        this.assertThat(properties).containsEntry((Object)"billingAddress", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("street", ToolSpecificationsTest.mapOf("type", "string"), "city", ToolSpecificationsTest.mapOf("type", "string"))));
        this.assertThat(properties).containsEntry((Object)"shippingAddress", ToolSpecificationsTest.mapOf("type", "object", "properties", ToolSpecificationsTest.mapOf("street", ToolSpecificationsTest.mapOf("type", "string"), "city", ToolSpecificationsTest.mapOf("type", "string"))));
    }

    public static class Wrapper {
        @Tool(value={"line1", "line2"})
        public int f(@P(value="foo") String p0, boolean p1, @P(value="b2") Boolean p2, byte p3, Byte p4, short p5, Short p6, int p7, Integer p8, long p9, Long p10, @P(value="biggy") BigInteger p11, float p12, Float p13, double p14, Double p15, @P(value="bigger") BigDecimal p16, String[] p17, Integer[] p18, Boolean[] p19, int[] p20, boolean[] p21, List<Integer> p22, Set<BigDecimal> p23, Collection<String> p24, List p25, Set p26, Collection p27, E p28, Person p29, @P(value="optional", required=false) int p30, @P(value="required") int p31) {
            return 42;
        }

        @Tool(name="func_name")
        public int g(@ToolMemoryId String memoryId) {
            return 42;
        }

        public int unused(int i) {
            return 42;
        }
    }

    public static enum E {
        A,
        B,
        C;

    }

    public static class Person {
        @Description(value={"Name of the person"})
        private String name;
        private List<String> aliases;
        private boolean active;
        private Person parent;
        private Address currentAddress;
        private List<Address> previousAddresses;

        public String getName() {
            return this.name;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean isActive() {
            return this.active;
        }

        public Person getParent() {
            return this.parent;
        }

        public Address getCurrentAddress() {
            return this.currentAddress;
        }

        public List<Address> getPreviousAddresses() {
            return this.previousAddresses;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setParent(Person parent) {
            this.parent = parent;
        }

        public void setCurrentAddress(Address currentAddress) {
            this.currentAddress = currentAddress;
        }

        public void setPreviousAddresses(List<Address> previousAddresses) {
            this.previousAddresses = previousAddresses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isActive() != other.isActive()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$aliases = this.getAliases();
            List<String> other$aliases = other.getAliases();
            if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
                return false;
            }
            Person this$parent = this.getParent();
            Person other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            Address this$currentAddress = this.getCurrentAddress();
            Address other$currentAddress = other.getCurrentAddress();
            if (this$currentAddress == null ? other$currentAddress != null : !this$currentAddress.equals(other$currentAddress)) {
                return false;
            }
            List<Address> this$previousAddresses = this.getPreviousAddresses();
            List<Address> other$previousAddresses = other.getPreviousAddresses();
            return !(this$previousAddresses == null ? other$previousAddresses != null : !((Object)this$previousAddresses).equals(other$previousAddresses));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Person;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isActive() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $aliases = this.getAliases();
            result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
            Person $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            Address $currentAddress = this.getCurrentAddress();
            result = result * 59 + ($currentAddress == null ? 43 : $currentAddress.hashCode());
            List<Address> $previousAddresses = this.getPreviousAddresses();
            result = result * 59 + ($previousAddresses == null ? 43 : ((Object)$previousAddresses).hashCode());
            return result;
        }

        public String toString() {
            return "ToolSpecificationsTest.Person(name=" + this.getName() + ", aliases=" + this.getAliases() + ", active=" + this.isActive() + ", parent=" + this.getParent() + ", currentAddress=" + this.getCurrentAddress() + ", previousAddresses=" + this.getPreviousAddresses() + ")";
        }
    }

    public static class CustomerRegistration {
        @Tool(value={"register a new customer"})
        boolean registerCustomer(Customer customer) {
            return true;
        }
    }

    public static class InvalidToolsWithDuplicateNames {
        @Tool(name="duplicate_name")
        public int oneMethod(String typeString) {
            return 42;
        }

        @Tool(name="duplicate_name")
        public int aDifferentMethod(int typeInt) {
            return 42;
        }
    }

    public static class InvalidToolsWithDuplicateMethodNames {
        @Tool
        public int duplicateMethod(String typeString) {
            return 42;
        }

        @Tool
        public int duplicateMethod(int typeInt) {
            return 42;
        }
    }

    public static class Customer {
        public String name;
        public Address billingAddress;
        public Address shippingAddress;

        public String getName() {
            return this.name;
        }

        public Address getBillingAddress() {
            return this.billingAddress;
        }

        public Address getShippingAddress() {
            return this.shippingAddress;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBillingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
        }

        public void setShippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Customer)) {
                return false;
            }
            Customer other = (Customer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Address this$billingAddress = this.getBillingAddress();
            Address other$billingAddress = other.getBillingAddress();
            if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) {
                return false;
            }
            Address this$shippingAddress = this.getShippingAddress();
            Address other$shippingAddress = other.getShippingAddress();
            return !(this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Customer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Address $billingAddress = this.getBillingAddress();
            result = result * 59 + ($billingAddress == null ? 43 : $billingAddress.hashCode());
            Address $shippingAddress = this.getShippingAddress();
            result = result * 59 + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
            return result;
        }

        public String toString() {
            return "ToolSpecificationsTest.Customer(name=" + this.getName() + ", billingAddress=" + this.getBillingAddress() + ", shippingAddress=" + this.getShippingAddress() + ")";
        }
    }

    public static class Address {
        private String street;
        private String city;
    }
}

