/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.pdf.PdfFile;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class PdfFileContentTest {
    PdfFileContentTest() {
    }

    @Test
    void test_methods() {
        PdfFile urlPdfFile = PdfFile.builder().url(URI.create("https://example.com/pdfFile.pdf")).build();
        PdfFileContent pdfFileContent = new PdfFileContent(urlPdfFile);
        Assertions.assertThat((Object)pdfFileContent.pdfFile()).isEqualTo((Object)urlPdfFile);
        Assertions.assertThat((Comparable)pdfFileContent.type()).isEqualTo((Object)ContentType.PDF);
        Assertions.assertThat((Object)pdfFileContent).hasToString("PdfFileContent { pdfFile = PdfFile { url = \"https://example.com/pdfFile.pdf\", base64Data = null } }");
    }

    @Test
    public void test_equals_hashCode() {
        PdfFileContent pdf1 = PdfFileContent.from((String)"https://example.com/pdfFile1.pdf");
        PdfFileContent pdf2 = PdfFileContent.from((String)"https://example.com/pdfFile1.pdf");
        PdfFileContent pdf3 = PdfFileContent.from((String)"https://example.com/pdfFile2.pdf");
        PdfFileContent pdf4 = PdfFileContent.from((String)"https://example.com/pdfFile2.pdf");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pdf1).isEqualTo((Object)pdf1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)pdf2)).hasSameHashCodeAs((Object)pdf2)).isNotEqualTo((Object)pdf3)).isNotEqualTo((Object)pdf4);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pdf3).isEqualTo((Object)pdf3)).isEqualTo((Object)pdf4)).hasSameHashCodeAs((Object)pdf4);
    }

    @Test
    public void test_builders() {
        PdfFile urlPdfFile = PdfFile.builder().url(URI.create("https://example.com/pdfFile.pdf")).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new PdfFileContent(urlPdfFile)).isEqualTo((Object)new PdfFileContent(urlPdfFile))).isEqualTo((Object)PdfFileContent.from((PdfFile)urlPdfFile))).isEqualTo((Object)PdfFileContent.from((PdfFile)urlPdfFile))).isEqualTo((Object)new PdfFileContent(urlPdfFile.url()))).isEqualTo((Object)new PdfFileContent(urlPdfFile.url().toString()))).isEqualTo((Object)PdfFileContent.from((URI)urlPdfFile.url()))).isEqualTo((Object)PdfFileContent.from((String)urlPdfFile.url().toString()));
        PdfFile base64pdfFile = PdfFile.builder().base64Data("cGRmDQo=").build();
        ((ObjectAssert)Assertions.assertThat((Object)new PdfFileContent(base64pdfFile)).isEqualTo((Object)new PdfFileContent(base64pdfFile))).isEqualTo((Object)PdfFileContent.from((PdfFile)base64pdfFile));
    }
}

