/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.JsonSchemaProperty;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public abstract class ChatModelListenerIT {
    protected abstract ChatLanguageModel createModel(ChatModelListener var1);

    protected abstract String modelName();

    protected Double temperature() {
        return 0.7;
    }

    protected Double topP() {
        return 1.0;
    }

    protected Integer maxTokens() {
        return 7;
    }

    protected abstract ChatLanguageModel createFailingModel(ChatModelListener var1);

    protected abstract Class<? extends Exception> expectedExceptionClass();

    @Test
    void should_listen_request_and_response() {
        final AtomicReference requestReference = new AtomicReference();
        final AtomicReference responseReference = new AtomicReference();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestReference.set(requestContext.request());
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                responseReference.set(responseContext.response());
                Assertions.assertThat((Object)responseContext.request()).isSameAs(requestReference.get());
                Assertions.assertThat(responseContext.attributes().get("id")).isEqualTo((Object)"12345");
            }

            public void onError(ChatModelErrorContext errorContext) {
                Fail.fail((String)"onError() must not be called");
            }
        };
        ChatLanguageModel model = this.createModel(listener);
        UserMessage userMessage = UserMessage.from((String)"hello");
        ToolSpecification toolSpecification = null;
        if (this.supportToolCalls()) {
            toolSpecification = ToolSpecification.builder().name("add").addParameter("a", new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER}).addParameter("b", new JsonSchemaProperty[]{JsonSchemaProperty.INTEGER}).build();
        }
        AiMessage aiMessage = this.supportToolCalls() ? (AiMessage)model.generate(Collections.singletonList(userMessage), Collections.singletonList(toolSpecification)).content() : (AiMessage)model.generate(Collections.singletonList(userMessage)).content();
        ChatModelRequest request = (ChatModelRequest)requestReference.get();
        Assertions.assertThat((String)request.model()).isEqualTo(this.modelName());
        Assertions.assertThat((Double)request.temperature()).isCloseTo(this.temperature(), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((Double)request.topP()).isEqualTo(this.topP());
        Assertions.assertThat((Integer)request.maxTokens()).isEqualTo((Object)this.maxTokens());
        Assertions.assertThat((List)request.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        if (this.supportToolCalls()) {
            Assertions.assertThat((List)request.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        }
        ChatModelResponse response = (ChatModelResponse)responseReference.get();
        if (this.assertResponseId()) {
            Assertions.assertThat((String)response.id()).isNotBlank();
        }
        Assertions.assertThat((String)response.model()).isNotBlank();
        Assertions.assertThat((Integer)response.tokenUsage().inputTokenCount()).isGreaterThan(0);
        Assertions.assertThat((Integer)response.tokenUsage().outputTokenCount()).isGreaterThan(0);
        Assertions.assertThat((Integer)response.tokenUsage().totalTokenCount()).isGreaterThan(0);
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)response.finishReason()).isNotNull();
        }
        Assertions.assertThat((Object)response.aiMessage()).isEqualTo((Object)aiMessage);
    }

    protected boolean supportToolCalls() {
        return true;
    }

    protected boolean assertResponseId() {
        return true;
    }

    protected boolean assertFinishReason() {
        return true;
    }

    @Test
    void should_listen_error() {
        final AtomicReference requestReference = new AtomicReference();
        final AtomicReference errorReference = new AtomicReference();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                requestReference.set(requestContext.request());
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                Fail.fail((String)"onResponse() must not be called");
            }

            public void onError(ChatModelErrorContext errorContext) {
                errorReference.set(errorContext.error());
                Assertions.assertThat((Object)errorContext.request()).isSameAs(requestReference.get());
                Assertions.assertThat((Object)errorContext.partialResponse()).isNull();
                Assertions.assertThat(errorContext.attributes().get("id")).isEqualTo((Object)"12345");
            }
        };
        ChatLanguageModel model = this.createFailingModel(listener);
        String userMessage = "this message will fail";
        try {
            model.generate(userMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable throwable = (Throwable)errorReference.get();
        Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(this.expectedExceptionClass());
    }
}

