/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;

public class TestStreamingResponseHandler<T>
implements StreamingResponseHandler<T> {
    private final CompletableFuture<Response<T>> futureResponse = new CompletableFuture();
    private final StringBuffer textContentBuilder = new StringBuffer();

    public void onNext(String token) {
        this.textContentBuilder.append(token);
    }

    public void onComplete(Response<T> response) {
        String expectedTextContent = this.textContentBuilder.toString();
        if (response.content() instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)response.content();
            if (aiMessage.hasToolExecutionRequests()) {
                Assertions.assertThat((int)aiMessage.toolExecutionRequests().size()).isGreaterThan(0);
            } else {
                Assertions.assertThat((String)aiMessage.text()).isEqualTo(expectedTextContent);
            }
        } else if (response.content() instanceof String) {
            Assertions.assertThat((Object)response.content()).isEqualTo((Object)expectedTextContent);
        } else {
            throw Exceptions.illegalArgument((String)("Unknown response content: " + response.content()), (Object[])new Object[0]);
        }
        this.futureResponse.complete(response);
    }

    public void onError(Throwable error) {
        this.futureResponse.completeExceptionally(error);
    }

    public Response<T> get() {
        return this.futureResponse.get(30L, TimeUnit.SECONDS);
    }
}

