/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.MetadataFilterBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullAndEmptySource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class EmbeddingStoreWithRemovalIT {
    protected abstract EmbeddingStore<TextSegment> embeddingStore();

    protected abstract EmbeddingModel embeddingModel();

    @Test
    void should_remove_by_id() {
        Embedding embedding1 = (Embedding)this.embeddingModel().embed("test1").content();
        String id1 = this.embeddingStore().add(embedding1);
        Embedding embedding2 = (Embedding)this.embeddingModel().embed("test2").content();
        String id2 = this.embeddingStore().add(embedding2);
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        this.embeddingStore().remove(id1);
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        Assertions.assertThat((String)this.getAllEmbeddings().get(0).embeddingId()).isEqualTo(id2);
    }

    @ParameterizedTest
    @NullAndEmptySource
    @ValueSource(strings={" "})
    void should_fail_to_remove_by_id(String id) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embeddingStore().remove(id)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("id cannot be null or blank");
    }

    @Test
    void should_remove_all_by_ids() {
        Embedding embedding1 = (Embedding)this.embeddingModel().embed("test1").content();
        String id1 = this.embeddingStore().add(embedding1);
        Embedding embedding2 = (Embedding)this.embeddingModel().embed("test2").content();
        String id2 = this.embeddingStore().add(embedding2);
        Embedding embedding3 = (Embedding)this.embeddingModel().embed("test3").content();
        String id3 = this.embeddingStore().add(embedding3);
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(3));
        this.embeddingStore().removeAll(Arrays.asList(id1, id2));
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        Assertions.assertThat((String)this.getAllEmbeddings().get(0).embeddingId()).isEqualTo(id3);
    }

    @Test
    void should_fail_to_remove_all_by_ids_null() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embeddingStore().removeAll((Collection)null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ids cannot be null or empty");
    }

    @Test
    void should_fail_to_remove_all_by_ids_empty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embeddingStore().removeAll(Collections.emptyList())).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("ids cannot be null or empty");
    }

    @Test
    void should_remove_all_by_filter() {
        TextSegment segment1 = TextSegment.from((String)"matching", (Metadata)Metadata.metadata((String)"type", (String)"a"));
        Embedding embedding1 = (Embedding)this.embeddingModel().embed(segment1).content();
        this.embeddingStore().add(embedding1, (Object)segment1);
        TextSegment segment2 = TextSegment.from((String)"matching", (Metadata)Metadata.metadata((String)"type", (String)"a"));
        Embedding embedding2 = (Embedding)this.embeddingModel().embed(segment2).content();
        this.embeddingStore().add(embedding2, (Object)segment2);
        Embedding embedding3 = (Embedding)this.embeddingModel().embed("not matching").content();
        String id3 = this.embeddingStore().add(embedding3);
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(3));
        this.embeddingStore().removeAll(MetadataFilterBuilder.metadataKey((String)"type").isEqualTo("a"));
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(1));
        Assertions.assertThat((String)this.getAllEmbeddings().get(0).embeddingId()).isEqualTo(id3);
    }

    @Test
    void should_fail_to_remove_all_by_filter_null() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embeddingStore().removeAll((Filter)null)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("filter cannot be null");
    }

    @Test
    void should_remove_all() {
        Embedding embedding1 = (Embedding)this.embeddingModel().embed("test1").content();
        this.embeddingStore().add(embedding1);
        Embedding embedding2 = (Embedding)this.embeddingModel().embed("test2").content();
        this.embeddingStore().add(embedding2);
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(2));
        this.embeddingStore().removeAll();
        this.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).isEmpty());
    }

    protected void awaitUntilAsserted(ThrowingRunnable assertion) {
        Awaitility.await().atMost(Duration.ofSeconds(60L)).pollDelay(Duration.ofSeconds(0L)).pollInterval(Duration.ofMillis(300L)).untilAsserted(assertion);
    }

    protected List<EmbeddingMatch<TextSegment>> getAllEmbeddings() {
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding((Embedding)this.embeddingModel().embed("test").content()).maxResults(Integer.valueOf(1000)).build();
        EmbeddingSearchResult searchResult = this.embeddingStore().search(embeddingSearchRequest);
        return searchResult.matches();
    }
}

