/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.List;
import java.util.Objects;

public class Metadata {
    private final UserMessage userMessage;
    private final Object chatMemoryId;
    private final List<ChatMessage> chatMemory;

    public Metadata(UserMessage userMessage, Object chatMemoryId, List<ChatMessage> chatMemory) {
        this.userMessage = ValidationUtils.ensureNotNull(userMessage, "userMessage");
        this.chatMemoryId = chatMemoryId;
        this.chatMemory = Utils.copyIfNotNull(chatMemory);
    }

    public UserMessage userMessage() {
        return this.userMessage;
    }

    public Object chatMemoryId() {
        return this.chatMemoryId;
    }

    public List<ChatMessage> chatMemory() {
        return this.chatMemory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.userMessage, that.userMessage) && Objects.equals(this.chatMemoryId, that.chatMemoryId) && Objects.equals(this.chatMemory, that.chatMemory);
    }

    public int hashCode() {
        return Objects.hash(this.userMessage, this.chatMemoryId, this.chatMemory);
    }

    public String toString() {
        return "Metadata { userMessage = " + String.valueOf(this.userMessage) + ", chatMemoryId = " + String.valueOf(this.chatMemoryId) + ", chatMemory = " + String.valueOf(this.chatMemory) + " }";
    }

    public static Metadata from(UserMessage userMessage, Object chatMemoryId, List<ChatMessage> chatMemory) {
        return new Metadata(userMessage, chatMemoryId, chatMemory);
    }
}

