/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.internal.JacocoIgnoreCoverageGenerated;
import java.util.Random;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtils {
    private static final Random RANDOM = new Random();
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);
    public static final RetryPolicy DEFAULT_RETRY_POLICY = RetryUtils.retryPolicyBuilder().maxAttempts(3).delayMillis(500).jitterScale(0.2).backoffExp(1.5).build();

    private RetryUtils() {
    }

    public static RetryPolicy.Builder retryPolicyBuilder() {
        return new RetryPolicy.Builder();
    }

    public static <T> T withRetry(Callable<T> action, int maxAttempts) {
        return DEFAULT_RETRY_POLICY.withRetry(action, maxAttempts);
    }

    public static <T> T withRetry(Callable<T> action) {
        return DEFAULT_RETRY_POLICY.withRetry(action);
    }

    public static final class RetryPolicy {
        private final int maxAttempts;
        private final int delayMillis;
        private final double jitterScale;
        private final double backoffExp;

        public RetryPolicy(int maxAttempts, int delayMillis, double jitterScale, double backoffExp) {
            this.maxAttempts = maxAttempts;
            this.delayMillis = delayMillis;
            this.jitterScale = jitterScale;
            this.backoffExp = backoffExp;
        }

        public double rawDelayMs(int attempt) {
            return (double)this.delayMillis * Math.pow(this.backoffExp, attempt - 1);
        }

        public int jitterDelayMillis(int attempt) {
            double delay = this.rawDelayMs(attempt);
            double jitter = delay * this.jitterScale;
            return (int)(delay + (double)RANDOM.nextInt((int)jitter));
        }

        @JacocoIgnoreCoverageGenerated
        public void sleep(int attempt) {
            try {
                Thread.sleep(this.jitterDelayMillis(attempt));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public <T> T withRetry(Callable<T> action) {
            return this.withRetry(action, this.maxAttempts);
        }

        public <T> T withRetry(Callable<T> action, int maxAttempts) {
            int attempt = 1;
            while (true) {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    if (attempt >= maxAttempts) {
                        throw new RuntimeException(e);
                    }
                    log.warn(String.format("Exception was thrown on attempt %s of %s", attempt, maxAttempts), (Throwable)e);
                    this.sleep(attempt);
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        public static final class Builder {
            private int maxAttempts = 3;
            private int delayMillis = 1000;
            private double jitterScale = 0.2;
            private double backoffExp = 1.5;

            public Builder maxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
                return this;
            }

            public Builder delayMillis(int delayMillis) {
                this.delayMillis = delayMillis;
                return this;
            }

            public Builder jitterScale(double jitterScale) {
                this.jitterScale = jitterScale;
                return this;
            }

            public Builder backoffExp(double backoffExp) {
                this.backoffExp = backoffExp;
                return this;
            }

            public RetryPolicy build() {
                return new RetryPolicy(this.maxAttempts, this.delayMillis, this.jitterScale, this.backoffExp);
            }
        }
    }
}

