/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import dev.langchain4j.Internal;
import dev.langchain4j.internal.Json;
import java.util.Optional;

@Internal
public class JsonParsingUtils {
    public static <T> Optional<ParsedJson<T>> extractAndParseJson(String text, Class<T> type) {
        return JsonParsingUtils.extractAndParseJson(text, (String s) -> Json.fromJson(s, type));
    }

    public static <T> Optional<ParsedJson<T>> extractAndParseJson(String text, ThrowingFunction<String, T> parser) {
        try {
            return Optional.of(new ParsedJson<T>(parser.apply(text), text));
        }
        catch (Exception exception) {
            int index = text.length();
            while (true) {
                int jsonEnd;
                if ((jsonEnd = JsonParsingUtils.findJsonEnd(text, index)) < 0) {
                    return Optional.empty();
                }
                int jsonStart = JsonParsingUtils.findJsonStart(text, jsonEnd, text.charAt(jsonEnd));
                if (jsonStart < 0) {
                    return Optional.empty();
                }
                try {
                    String tentativeJson = text.substring(jsonStart, jsonEnd + 1);
                    return Optional.of(new ParsedJson<T>(parser.apply(tentativeJson), tentativeJson));
                }
                catch (Exception exception2) {
                    index = jsonStart;
                    continue;
                }
                break;
            }
        }
    }

    private static int findJsonEnd(String text, int fromIndex) {
        int jsonMapEnd = text.lastIndexOf(125, fromIndex);
        int jsonListEnd = text.lastIndexOf(93, fromIndex);
        return Math.max(jsonMapEnd, jsonListEnd);
    }

    private static int findJsonStart(String text, int jsonEnd, char closingBrace) {
        char openingBrace = closingBrace == '}' ? (char)'{' : '[';
        int braceCount = 0;
        for (int i = jsonEnd; i >= 0; --i) {
            char c = text.charAt(i);
            if (c == openingBrace) {
                if (++braceCount != 0) continue;
                return i == 0 || text.charAt(i - 1) != openingBrace ? i : -1;
            }
            if (c != closingBrace) continue;
            --braceCount;
        }
        return -1;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    public record ParsedJson<T>(T value, String json) {
    }
}

