/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.jdk;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.jdk.JdkHttpClientBuilder;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class JdkHttpClient
implements HttpClient {
    private final java.net.http.HttpClient delegate;
    private final Duration readTimeout;

    public JdkHttpClient(JdkHttpClientBuilder builder) {
        HttpClient.Builder httpClientBuilder = (HttpClient.Builder)Utils.getOrDefault((Object)builder.httpClientBuilder(), java.net.http.HttpClient::newBuilder);
        if (builder.connectTimeout() != null) {
            httpClientBuilder.connectTimeout(builder.connectTimeout());
        }
        this.delegate = httpClientBuilder.build();
        this.readTimeout = builder.readTimeout();
    }

    public SuccessfulHttpResponse execute(HttpRequest request) throws HttpException {
        try {
            java.net.http.HttpRequest jdkRequest = this.toJdkRequest(request);
            HttpResponse<String> jdkResponse = this.delegate.send(jdkRequest, HttpResponse.BodyHandlers.ofString());
            if (!JdkHttpClient.isSuccessful(jdkResponse)) {
                throw new HttpException(jdkResponse.statusCode(), jdkResponse.body());
            }
            return JdkHttpClient.fromJdkResponse(jdkResponse, jdkResponse.body());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
        java.net.http.HttpRequest jdkRequest = this.toJdkRequest(request);
        ((CompletableFuture)this.delegate.sendAsync(jdkRequest, HttpResponse.BodyHandlers.ofInputStream()).thenAccept(jdkResponse -> {
            if (!JdkHttpClient.isSuccessful(jdkResponse)) {
                listener.onError((Throwable)new HttpException(jdkResponse.statusCode(), JdkHttpClient.readBody(jdkResponse)));
                return;
            }
            SuccessfulHttpResponse response = JdkHttpClient.fromJdkResponse(jdkResponse, null);
            listener.onOpen(response);
            try (InputStream inputStream = (InputStream)jdkResponse.body();){
                parser.parse(inputStream, listener);
                listener.onClose();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).exceptionally(throwable -> {
            if (throwable.getCause() instanceof HttpTimeoutException) {
                listener.onError(throwable);
            }
            return null;
        });
    }

    private java.net.http.HttpRequest toJdkRequest(HttpRequest request) {
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(URI.create(request.url()));
        request.headers().forEach((name, values) -> {
            if (values != null) {
                values.forEach(value -> builder.header((String)name, (String)value));
            }
        });
        HttpRequest.BodyPublisher bodyPublisher = request.body() != null ? HttpRequest.BodyPublishers.ofString(request.body()) : HttpRequest.BodyPublishers.noBody();
        builder.method(request.method().name(), bodyPublisher);
        if (this.readTimeout != null) {
            builder.timeout(this.readTimeout);
        }
        return builder.build();
    }

    private static SuccessfulHttpResponse fromJdkResponse(HttpResponse<?> response, String body) {
        return SuccessfulHttpResponse.builder().statusCode(response.statusCode()).headers(response.headers().map()).body(body).build();
    }

    private static boolean isSuccessful(HttpResponse<?> response) {
        int statusCode = response.statusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readBody(HttpResponse<InputStream> response) {
        try (InputStream inputStream = response.body();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            return string;
        }
        catch (IOException e) {
            return "Cannot read error response body: " + e.getMessage();
        }
    }
}

