/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.ollama.InternalOllamaHelper;
import dev.langchain4j.model.ollama.Message;
import dev.langchain4j.model.ollama.OllamaChatResponse;
import dev.langchain4j.model.ollama.ToolCall;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class OllamaStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private volatile String modelName;
    private volatile TokenUsage tokenUsage;
    private final List<ToolExecutionRequest> toolExecutionRequests = new CopyOnWriteArrayList<ToolExecutionRequest>();

    OllamaStreamingResponseBuilder() {
    }

    void append(OllamaChatResponse partialResponse) {
        String content;
        Message message;
        if (partialResponse == null) {
            return;
        }
        if (this.modelName == null && partialResponse.getModel() != null) {
            this.modelName = partialResponse.getModel();
        }
        if (partialResponse.getEvalCount() != null && partialResponse.getPromptEvalCount() != null) {
            this.tokenUsage = new TokenUsage(partialResponse.getPromptEvalCount(), partialResponse.getEvalCount());
        }
        if ((message = partialResponse.getMessage()) == null) {
            return;
        }
        List<ToolCall> toolCalls = message.getToolCalls();
        if (!Utils.isNullOrEmpty(toolCalls)) {
            this.toolExecutionRequests.addAll(InternalOllamaHelper.toToolExecutionRequests(toolCalls));
        }
        if ((content = message.getContent()) != null) {
            this.contentBuilder.append(content);
        }
    }

    ChatResponse build(OllamaChatResponse ollamaChatResponse) {
        if (!Utils.isNullOrEmpty(this.toolExecutionRequests)) {
            return ChatResponse.builder().aiMessage(AiMessage.from(this.toolExecutionRequests)).metadata(InternalOllamaHelper.chatResponseMetadataFrom(this.modelName, FinishReason.TOOL_EXECUTION, this.tokenUsage)).build();
        }
        String text = this.contentBuilder.toString();
        if (text.isEmpty()) {
            return null;
        }
        return ChatResponse.builder().aiMessage(AiMessage.from((String)text)).metadata(InternalOllamaHelper.chatResponseMetadataFrom(this.modelName, InternalOllamaHelper.toFinishReason(ollamaChatResponse), this.tokenUsage)).build();
    }
}

