/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.IntArrayList;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiEmbeddingModelName;
import dev.langchain4j.model.openai.OpenAiLanguageModelName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class OpenAiTokenizer
implements Tokenizer {
    private final String modelName;
    private final Optional<Encoding> encoding;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public OpenAiTokenizer(OpenAiChatModelName modelName) {
        this(modelName.toString());
    }

    public OpenAiTokenizer(OpenAiEmbeddingModelName modelName) {
        this(modelName.toString());
    }

    public OpenAiTokenizer(OpenAiLanguageModelName modelName) {
        this(modelName.toString());
    }

    public OpenAiTokenizer(String modelName) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.encoding = modelName.startsWith("o1") || modelName.startsWith("o3") ? Encodings.newLazyEncodingRegistry().getEncoding("o200k_base") : Encodings.newLazyEncodingRegistry().getEncodingForModel(modelName);
    }

    public int estimateTokenCountInText(String text) {
        return this.encoding.orElseThrow(this.unknownModelException()).countTokensOrdinary(text);
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        int tokenCount = 1;
        tokenCount += this.extraTokensPerMessage();
        if (message instanceof SystemMessage) {
            tokenCount += this.estimateTokenCountIn((SystemMessage)message);
        } else if (message instanceof UserMessage) {
            tokenCount += this.estimateTokenCountIn((UserMessage)message);
        } else if (message instanceof AiMessage) {
            tokenCount += this.estimateTokenCountIn((AiMessage)message);
        } else if (message instanceof ToolExecutionResultMessage) {
            tokenCount += this.estimateTokenCountIn((ToolExecutionResultMessage)message);
        } else {
            throw new IllegalArgumentException("Unknown message type: " + String.valueOf(message));
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(SystemMessage systemMessage) {
        return this.estimateTokenCountInText(systemMessage.text());
    }

    private int estimateTokenCountIn(UserMessage userMessage) {
        int tokenCount = 0;
        for (Content content : userMessage.contents()) {
            if (content instanceof TextContent) {
                tokenCount += this.estimateTokenCountInText(((TextContent)content).text());
                continue;
            }
            if (content instanceof ImageContent) {
                tokenCount += 85;
                continue;
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
        }
        if (userMessage.name() != null) {
            tokenCount += this.extraTokensPerName();
            tokenCount += this.estimateTokenCountInText(userMessage.name());
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(AiMessage aiMessage) {
        int tokenCount = 0;
        if (aiMessage.text() != null) {
            tokenCount += this.estimateTokenCountInText(aiMessage.text());
        }
        if (aiMessage.toolExecutionRequests() != null) {
            tokenCount = this.isOneOfLatestModels() ? (tokenCount += 6) : (tokenCount += 3);
            if (aiMessage.toolExecutionRequests().size() == 1) {
                --tokenCount;
                ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name()) * 2;
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.arguments());
            } else {
                tokenCount += 15;
                for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                    Map arguments;
                    tokenCount += 7;
                    tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name());
                    try {
                        arguments = (Map)OBJECT_MAPPER.readValue(toolExecutionRequest.arguments(), Map.class);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                    for (Map.Entry argument : arguments.entrySet()) {
                        tokenCount += 2;
                        tokenCount += this.estimateTokenCountInText(argument.getKey().toString());
                        tokenCount += this.estimateTokenCountInText(argument.getValue().toString());
                    }
                }
            }
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(ToolExecutionResultMessage toolExecutionResultMessage) {
        return this.estimateTokenCountInText(toolExecutionResultMessage.text());
    }

    private int extraTokensPerMessage() {
        if (this.modelName.equals("gpt-3.5-turbo-0301")) {
            return 4;
        }
        return 3;
    }

    private int extraTokensPerName() {
        if (this.modelName.equals("gpt-3.5-turbo-0301")) {
            return -1;
        }
        return 1;
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int tokenCount = 3;
        for (ChatMessage message : messages) {
            tokenCount += this.estimateTokenCountInMessage(message);
        }
        return tokenCount;
    }

    public List<Integer> encode(String text) {
        return this.encoding.orElseThrow(this.unknownModelException()).encodeOrdinary(text).boxed();
    }

    public List<Integer> encode(String text, int maxTokensToEncode) {
        return this.encoding.orElseThrow(this.unknownModelException()).encodeOrdinary(text, maxTokensToEncode).getTokens().boxed();
    }

    public String decode(List<Integer> tokens) {
        IntArrayList intArrayList = new IntArrayList();
        for (Integer token : tokens) {
            intArrayList.add(token.intValue());
        }
        return this.encoding.orElseThrow(this.unknownModelException()).decode(intArrayList);
    }

    private Supplier<IllegalArgumentException> unknownModelException() {
        return () -> Exceptions.illegalArgument((String)"Model '%s' is unknown to jtokkit", (Object[])new Object[]{this.modelName});
    }

    private boolean isOneOfLatestModels() {
        return this.isOneOfLatestGpt3Models() || this.isOneOfLatestGpt4Models();
    }

    private boolean isOneOfLatestGpt3Models() {
        return this.modelName.equals(OpenAiChatModelName.GPT_3_5_TURBO_1106.toString()) || this.modelName.equals(OpenAiChatModelName.GPT_3_5_TURBO_0125.toString());
    }

    private boolean isOneOfLatestGpt4Models() {
        return this.modelName.equals(OpenAiChatModelName.GPT_4_TURBO_PREVIEW.toString()) || this.modelName.equals(OpenAiChatModelName.GPT_4_1106_PREVIEW.toString()) || this.modelName.equals(OpenAiChatModelName.GPT_4_0125_PREVIEW.toString());
    }
}

