/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.zhipu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.zhipu.Json;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class AuthorizationInterceptor
implements Interceptor {
    private static final long expireMillis = 1800000L;
    private static final String id = "HS256";
    private static final String jcaName = "HmacSHA256";
    private static final MacAlgorithm macAlgorithm;
    private final String apiKey;
    private final Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMillis(1800000L)).build();

    public AuthorizationInterceptor(String apiKey) {
        this.apiKey = apiKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String token = (String)Utils.getOrDefault((Object)((String)this.cache.getIfPresent((Object)this.apiKey)), (Object)this.generateToken());
        Request request = chain.request().newBuilder().addHeader("Authorization", "Bearer " + token).removeHeader("Accept").build();
        return chain.proceed(request);
    }

    private String generateToken() {
        String[] apiKeyParts = this.apiKey.split("\\.");
        String keyId = apiKeyParts[0];
        String secret = apiKeyParts[1];
        HashMap<String, Object> payload = new HashMap<String, Object>(3);
        payload.put("api_key", keyId);
        payload.put("exp", System.currentTimeMillis() + 1800000L);
        payload.put("timestamp", System.currentTimeMillis());
        String token = ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)"alg", (Object)id)).add((Object)"sign_type", (Object)"SIGN")).and()).content(Json.toJson(payload)).signWith((Key)new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), jcaName), (SecureDigestAlgorithm)macAlgorithm).compact();
        this.cache.put((Object)this.apiKey, (Object)token);
        return token;
    }

    static {
        try {
            int minKeyBitLength = 128;
            Class<?> c = Class.forName("io.jsonwebtoken.impl.security.DefaultMacAlgorithm");
            Constructor<?> ctor = c.getDeclaredConstructor(String.class, String.class, Integer.TYPE);
            ctor.setAccessible(true);
            macAlgorithm = (MacAlgorithm)ctor.newInstance(id, jcaName, minKeyBitLength);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

