/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.User;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManagerDelegate;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordEncoderUtil;
import com.alibaba.nacos.plugin.auth.impl.utils.PasswordGeneratorUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="user")
@RequestMapping(value={"/v1/auth", "/v1/auth/users"})
public class UserController {
    @Autowired
    private TokenManagerDelegate jwtTokenManager;
    @Autowired
    @Deprecated
    private AuthenticationManager authenticationManager;
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private NacosRoleServiceImpl roleService;
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private IAuthenticationManager iAuthenticationManager;

    @Secured(resource="console/users", action=ActionTypes.WRITE)
    @PostMapping
    public Object createUser(@RequestParam String username, @RequestParam String password) {
        User user = this.userDetailsService.getUserFromDatabase(username);
        if (user != null) {
            throw new IllegalArgumentException("user '" + username + "' already exist!");
        }
        this.userDetailsService.createUser(username, PasswordEncoderUtil.encode(password));
        return RestResultUtils.success((Object)"create user ok!");
    }

    @PostMapping(value={"/admin"})
    public Object createAdminUser(@RequestParam(required=false) String username, @RequestParam(required=false) String password) {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            if (this.roleService.hasGlobalAdminRole()) {
                return RestResultUtils.failed((String)"have admin user cannot use it");
            }
            if (StringUtils.isBlank((CharSequence)password)) {
                password = PasswordGeneratorUtil.generateRandomPassword();
            }
            if (StringUtils.isBlank((CharSequence)username)) {
                username = "nacos";
            }
            this.userDetailsService.createUser(username, PasswordEncoderUtil.encode(password));
            this.roleService.addAdminRole(username);
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("username", username);
            result.put("password", password);
            return result;
        }
        return RestResultUtils.failed((String)"not support");
    }

    @DeleteMapping
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public Object deleteUser(@RequestParam String username) {
        List<RoleInfo> roleInfoList = this.roleService.getRoles(username);
        if (roleInfoList != null) {
            for (RoleInfo roleInfo : roleInfoList) {
                if (!"ROLE_ADMIN".equals(roleInfo.getRole())) continue;
                throw new IllegalArgumentException("cannot delete admin: " + username);
            }
        }
        this.userDetailsService.deleteUser(username);
        return RestResultUtils.success((Object)"delete user ok!");
    }

    @PutMapping
    @Secured(resource="console/user/password", action=ActionTypes.WRITE)
    public Object updateUser(@RequestParam String username, @RequestParam String newPassword, HttpServletResponse response, HttpServletRequest request) throws IOException {
        try {
            if (!this.hasPermission(username, request)) {
                response.sendError(403, "authorization failed!");
                return null;
            }
        }
        catch (HttpSessionRequiredException e) {
            response.sendError(401, "session expired!");
            return null;
        }
        catch (AccessException exception) {
            response.sendError(403, "authorization failed!");
            return null;
        }
        User user = this.userDetailsService.getUserFromDatabase(username);
        if (user == null) {
            throw new IllegalArgumentException("user " + username + " not exist!");
        }
        this.userDetailsService.updateUserPassword(username, PasswordEncoderUtil.encode(newPassword));
        return RestResultUtils.success((Object)"update user ok!");
    }

    private boolean hasPermission(String username, HttpServletRequest request) throws HttpSessionRequiredException, AccessException {
        if (!this.authConfigs.isAuthEnabled()) {
            return true;
        }
        IdentityContext identityContext = (IdentityContext)request.getSession().getAttribute("identity_context");
        if (identityContext == null) {
            throw new HttpSessionRequiredException("session expired!");
        }
        NacosUser user = (NacosUser)identityContext.getParameter("nacosuser");
        if (user == null) {
            user = this.iAuthenticationManager.authenticate(request);
            if (user == null) {
                throw new HttpSessionRequiredException("session expired!");
            }
            this.iAuthenticationManager.hasGlobalAdminRole(user);
        }
        if (user.isGlobalAdmin()) {
            return true;
        }
        return user.getUserName().equals(username);
    }

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/users", action=ActionTypes.READ)
    public Page<User> getUsers(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", required=false, defaultValue="") String username) {
        return this.userDetailsService.getUsersFromDatabase(pageNo, pageSize, username);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/users", action=ActionTypes.READ)
    public Page<User> fuzzySearchUser(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", required=false, defaultValue="") String username) {
        return this.userDetailsService.findUsersLike4Page(username, pageNo, pageSize);
    }

    @PostMapping(value={"/login"})
    public Object login(@RequestParam String username, @RequestParam String password, HttpServletResponse response, HttpServletRequest request) throws AccessException, IOException {
        if (AuthSystemTypes.NACOS.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType()) || AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            if (!this.iAuthenticationManager.hasGlobalAdminRole()) {
                response.sendError(412, "admin role user not exist");
                return null;
            }
            NacosUser user = this.iAuthenticationManager.authenticate(request);
            response.addHeader("Authorization", "Bearer " + user.getToken());
            ObjectNode result = JacksonUtils.createEmptyJsonNode();
            result.put("accessToken", user.getToken());
            result.put("tokenTtl", this.jwtTokenManager.getTokenTtlInSeconds(user.getToken()));
            result.put("globalAdmin", this.iAuthenticationManager.hasGlobalAdminRole(user));
            result.put("username", user.getUserName());
            return result;
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            String token = this.jwtTokenManager.createToken(authentication);
            response.addHeader("Authorization", "Bearer " + token);
            return RestResultUtils.success((Object)("Bearer " + token));
        }
        catch (BadCredentialsException authentication) {
            return RestResultUtils.failed((int)HttpStatus.UNAUTHORIZED.value(), null, (String)"Login failed");
        }
    }

    @PutMapping(value={"/password"})
    @Deprecated
    public RestResult<String> updatePassword(@RequestParam(value="oldPassword") String oldPassword, @RequestParam(value="newPassword") String newPassword) {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = ((UserDetails)principal).getUsername();
        User user = this.userDetailsService.getUserFromDatabase(username);
        String password = user.getPassword();
        try {
            if (PasswordEncoderUtil.matches(oldPassword, password).booleanValue()) {
                this.userDetailsService.updateUserPassword(username, PasswordEncoderUtil.encode(newPassword));
                return RestResultUtils.success((Object)"Update password success");
            }
            return RestResultUtils.failed((int)HttpStatus.UNAUTHORIZED.value(), (Object)"Old password is invalid");
        }
        catch (Exception e) {
            return RestResultUtils.failed((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)"Update userpassword failed");
        }
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/users", action=ActionTypes.WRITE)
    public List<String> searchUsersLikeUsername(@RequestParam String username) {
        return this.userDetailsService.findUserLikeUsername(username);
    }
}

