/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.roles;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RolePersistService;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class NacosRoleServiceImpl {
    private static final int DEFAULT_PAGE_NO = 1;
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private RolePersistService rolePersistService;
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private PermissionPersistService permissionPersistService;
    private volatile Set<String> roleSet = new ConcurrentHashSet();
    private volatile Map<String, List<RoleInfo>> roleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>();
    private volatile Map<String, List<PermissionInfo>> permissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>();

    @Scheduled(initialDelay=5000L, fixedDelay=15000L)
    private void reload() {
        try {
            Page<RoleInfo> roleInfoPage = this.rolePersistService.getRolesByUserNameAndRoleName("", "", 1, Integer.MAX_VALUE);
            if (roleInfoPage == null) {
                return;
            }
            HashSet<String> tmpRoleSet = new HashSet<String>(16);
            ConcurrentHashMap<String, List<RoleInfo>> tmpRoleInfoMap = new ConcurrentHashMap<String, List<RoleInfo>>(16);
            for (RoleInfo roleInfo : roleInfoPage.getPageItems()) {
                if (!tmpRoleInfoMap.containsKey(roleInfo.getUsername())) {
                    tmpRoleInfoMap.put(roleInfo.getUsername(), new ArrayList());
                }
                ((List)tmpRoleInfoMap.get(roleInfo.getUsername())).add(roleInfo);
                tmpRoleSet.add(roleInfo.getRole());
            }
            ConcurrentHashMap<String, List<PermissionInfo>> tmpPermissionInfoMap = new ConcurrentHashMap<String, List<PermissionInfo>>(16);
            for (String role : tmpRoleSet) {
                Page<PermissionInfo> permissionInfoPage = this.permissionPersistService.getPermissions(role, 1, Integer.MAX_VALUE);
                tmpPermissionInfoMap.put(role, permissionInfoPage.getPageItems());
            }
            this.roleSet = tmpRoleSet;
            this.roleInfoMap = tmpRoleInfoMap;
            this.permissionInfoMap = tmpPermissionInfoMap;
        }
        catch (Exception e) {
            Loggers.AUTH.warn("[LOAD-ROLES] load failed", (Throwable)e);
        }
    }

    public boolean hasPermission(NacosUser nacosUser, Permission permission) {
        if ("console/user/password".equals(permission.getResource().getName())) {
            return true;
        }
        List<RoleInfo> roleInfoList = this.getRoles(nacosUser.getUserName());
        if (CollectionUtils.isEmpty(roleInfoList)) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            if (!"ROLE_ADMIN".equals(roleInfo.getRole())) continue;
            nacosUser.setGlobalAdmin(true);
            return true;
        }
        if (permission.getResource().getName().startsWith("console/")) {
            return false;
        }
        for (RoleInfo roleInfo : roleInfoList) {
            List<PermissionInfo> permissionInfoList = this.getPermissions(roleInfo.getRole());
            if (CollectionUtils.isEmpty(permissionInfoList)) continue;
            for (PermissionInfo permissionInfo : permissionInfoList) {
                String permissionResource = permissionInfo.getResource().replaceAll("\\*", ".*");
                String permissionAction = permissionInfo.getAction();
                if (!permissionAction.contains(permission.getAction()) || !Pattern.matches(permissionResource, this.joinResource(permission.getResource()))) continue;
                return true;
            }
        }
        return false;
    }

    public List<RoleInfo> getRoles(String username) {
        Page<RoleInfo> roleInfoPage;
        List roleInfoList = this.roleInfoMap.get(username);
        if (!(this.authConfigs.isCachingEnabled() && roleInfoList != null || (roleInfoPage = this.getRolesFromDatabase(username, "", 1, Integer.MAX_VALUE)) == null || CollectionUtils.isEmpty((Collection)(roleInfoList = roleInfoPage.getPageItems())))) {
            this.roleInfoMap.put(username, roleInfoList);
        }
        return roleInfoList;
    }

    public List<RoleInfo> getAllRoles() {
        Page<RoleInfo> roleInfoPage = this.rolePersistService.getRolesByUserNameAndRoleName("", "", 1, Integer.MAX_VALUE);
        if (roleInfoPage == null) {
            return null;
        }
        return roleInfoPage.getPageItems();
    }

    public Page<RoleInfo> getRolesFromDatabase(String userName, String role, int pageNo, int pageSize) {
        Page<RoleInfo> roles = this.rolePersistService.getRolesByUserNameAndRoleName(userName, role, pageNo, pageSize);
        if (roles == null) {
            return new Page();
        }
        return roles;
    }

    public List<PermissionInfo> getPermissions(String role) {
        Page<PermissionInfo> permissionInfoPage;
        List permissionInfoList = this.permissionInfoMap.get(role);
        if (!(this.authConfigs.isCachingEnabled() && permissionInfoList != null || (permissionInfoPage = this.getPermissionsFromDatabase(role, 1, Integer.MAX_VALUE)) == null || CollectionUtils.isEmpty((Collection)(permissionInfoList = permissionInfoPage.getPageItems())))) {
            this.permissionInfoMap.put(role, permissionInfoList);
        }
        return permissionInfoList;
    }

    public Page<PermissionInfo> getPermissionsByRoleFromDatabase(String role, int pageNo, int pageSize) {
        return this.permissionPersistService.getPermissions(role, pageNo, pageSize);
    }

    public void addRole(String role, String username) {
        if (this.userDetailsService.getUserFromDatabase(username) == null) {
            throw new IllegalArgumentException("user '" + username + "' not found!");
        }
        if ("ROLE_ADMIN".equals(role)) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' is not permitted to create!");
        }
        this.rolePersistService.addRole(role, username);
        this.roleSet.add(role);
    }

    public void addAdminRole(String username) {
        if (this.userDetailsService.getUserFromDatabase(username) == null) {
            throw new IllegalArgumentException("user '" + username + "' not found!");
        }
        if (this.hasGlobalAdminRole()) {
            throw new IllegalArgumentException("role 'ROLE_ADMIN' already exist !");
        }
        this.rolePersistService.addRole("ROLE_ADMIN", username);
        this.roleSet.add("ROLE_ADMIN");
        this.authConfigs.setHasGlobalAdminRole(true);
    }

    public void deleteRole(String role, String userName) {
        this.rolePersistService.deleteRole(role, userName);
    }

    public void deleteRole(String role) {
        this.rolePersistService.deleteRole(role);
        this.roleSet.remove(role);
    }

    public Page<PermissionInfo> getPermissionsFromDatabase(String role, int pageNo, int pageSize) {
        Page<PermissionInfo> pageInfo = this.permissionPersistService.getPermissions(role, pageNo, pageSize);
        if (pageInfo == null) {
            return new Page();
        }
        return pageInfo;
    }

    public void addPermission(String role, String resource, String action) {
        if (!this.roleSet.contains(role)) {
            throw new IllegalArgumentException("role " + role + " not found!");
        }
        this.permissionPersistService.addPermission(role, resource, action);
    }

    public void deletePermission(String role, String resource, String action) {
        this.permissionPersistService.deletePermission(role, resource, action);
    }

    public List<String> findRolesLikeRoleName(String role) {
        return this.rolePersistService.findRolesLikeRoleName(role);
    }

    private String joinResource(Resource resource) {
        String group;
        if ("specified".equals(resource.getType())) {
            return resource.getName();
        }
        StringBuilder result = new StringBuilder();
        String namespaceId = resource.getNamespaceId();
        if (StringUtils.isNotBlank((String)namespaceId) && !"public".equals(namespaceId)) {
            result.append(namespaceId);
        }
        if (StringUtils.isBlank((CharSequence)(group = resource.getGroup()))) {
            result.append(":").append('*');
        } else {
            result.append(":").append(group);
        }
        String resourceName = resource.getName();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            result.append(":").append(resource.getType().toLowerCase()).append("/*");
        } else {
            result.append(":").append(resource.getType().toLowerCase()).append('/').append(resourceName);
        }
        return result.toString();
    }

    public Page<RoleInfo> findRolesLike4Page(String username, String role, int pageNo, int pageSize) {
        return this.rolePersistService.findRolesLike4Page(username, role, pageNo, pageSize);
    }

    public Page<PermissionInfo> findPermissionsLike4Page(String role, int pageNo, int pageSize) {
        return this.permissionPersistService.findPermissionsLike4Page(role, pageNo, pageSize);
    }

    public boolean hasGlobalAdminRole(String userName) {
        List<RoleInfo> roles = this.getRoles(userName);
        return roles.stream().anyMatch(roleInfo -> "ROLE_ADMIN".equals(roleInfo.getRole()));
    }

    public boolean hasGlobalAdminRole() {
        if (this.authConfigs.isHasGlobalAdminRole()) {
            return true;
        }
        List<RoleInfo> roles = this.getAllRoles();
        boolean hasGlobalAdminRole = CollectionUtils.isNotEmpty(roles) && roles.stream().anyMatch(roleInfo -> "ROLE_ADMIN".equals(roleInfo.getRole()));
        this.authConfigs.setHasGlobalAdminRole(hasGlobalAdminRole);
        return hasGlobalAdminRole;
    }
}

