/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.module;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleStateHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleStateHolder.class);
    private static final ModuleStateHolder INSTANCE = new ModuleStateHolder();
    private final Map<String, ModuleState> moduleStates = new HashMap<String, ModuleState>();

    private ModuleStateHolder() {
        for (ModuleStateBuilder each : NacosServiceLoader.load(ModuleStateBuilder.class)) {
            if (each.isIgnore()) continue;
            try {
                ModuleState moduleState = each.build();
                this.moduleStates.put(moduleState.getModuleName(), moduleState);
            }
            catch (Exception e) {
                LOGGER.warn("Build ModuleState failed in builder:{}", (Object)each.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    public static ModuleStateHolder getInstance() {
        return INSTANCE;
    }

    public Optional<ModuleState> getModuleState(String moduleName) {
        return Optional.ofNullable(this.moduleStates.get(moduleName));
    }

    public Set<ModuleState> getAllModuleStates() {
        return new HashSet<ModuleState>(this.moduleStates.values());
    }

    public String getStateValueByName(String moduleName, String stateName) {
        return this.getStateValueByName(moduleName, stateName, "");
    }

    public <T> T getStateValueByName(String moduleName, String stateName, T defaultValue) {
        Optional<ModuleState> moduleState = this.getModuleState(moduleName);
        if (!moduleState.isPresent()) {
            return defaultValue;
        }
        return moduleState.get().getState(stateName, defaultValue);
    }

    public <T> T searchStateValue(String stateName, T defaultValue) {
        Object result = null;
        for (ModuleState each : this.getAllModuleStates()) {
            if (!each.getStates().containsKey(stateName)) continue;
            result = each.getStates().get(stateName);
            break;
        }
        return (T)(null == result ? defaultValue : result);
    }
}

