/*
 * Decompiled with CFR 0.152.
 */
package com.primexpy.openapi.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.primexpy.openapi.code.RSACoder;
import com.primexpy.openapi.pojo.OpenApiBody;
import com.primexpy.openapi.pojo.OpenApiKeyPair;
import com.primexpy.openapi.res.CommonRes;
import com.primexpy.openapi.utils.OpenApiUtil;
import java.util.concurrent.FutureTask;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiClient.class);
    private String sysPriKey;
    private String thirdPubKey;
    private String app;

    private OpenApiClient(String sysPriKey, String thirdPubKey, String app) {
        this.sysPriKey = sysPriKey;
        this.thirdPubKey = thirdPubKey;
        this.app = app;
    }

    public static OpenApiClient instance(String sysPriKey, String thirdPubKey, String app) {
        return new OpenApiClient(sysPriKey, thirdPubKey, app);
    }

    @Deprecated
    public <S> S request(String url, Object req, Class<S> beanClass) throws Exception {
        return this.req(url, req, beanClass, "");
    }

    public <S> S request(String url, Object req, Class<S> beanClass, String salt) throws Exception {
        Validate.notEmpty((CharSequence)salt, (String)"OpenApiClient validate error: salt can't be empty", (Object[])new Object[0]);
        return this.req(url, req, beanClass, salt);
    }

    public static OpenApiKeyPair generatePrivateAndPublicKey() throws Exception {
        return RSACoder.generatePrivateAndPublicKey();
    }

    private <S> S req(String url, Object req, Class<S> beanClass, String salt) throws Exception {
        FutureTask<Object> task = new FutureTask<Object>(() -> this.reqTask(url, req, beanClass, salt));
        new Thread(task).start();
        return (S)task.get();
    }

    private <S> S reqTask(String url, Object req, Class<S> beanClass, String salt) throws Exception {
        String reqStr = JSONUtil.toJsonStr((Object)req);
        log.info("OpenApiClient url: {} req: {}", (Object)url, (Object)reqStr);
        OpenApiBody openApiBody = OpenApiUtil.encrypt(reqStr, this.thirdPubKey);
        String reqSign = OpenApiUtil.sign(openApiBody, this.sysPriKey, salt);
        String reqBody = JSONUtil.toJsonStr((Object)openApiBody);
        String ts = String.valueOf(System.currentTimeMillis());
        log.info("OpenApiClient >>>>>>>>>>>>>>>>>>> url: {} app:{} ts: {} reqSign: {} reqBody: {}", new Object[]{url, this.app, ts, reqSign, reqBody});
        HttpResponse executeRes = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)url).header("Content-Type", "application/json")).header("sign", reqSign)).header("app", this.app)).header("timestamp", ts)).body(reqBody).execute();
        int status = executeRes.getStatus();
        String resBody = executeRes.body();
        String resSign = executeRes.header("sign");
        String resApp = executeRes.header("app");
        log.info("OpenApiClient <<<<<<<<<<<<<<<<<< httpStatus: {} resSign: {} resApp: {} resBody: {} ", new Object[]{status, resSign, resApp, resBody});
        if (status != 200) {
            log.info("OpenApiClient error res: {}", (Object)resBody);
            CommonRes commonRes = (CommonRes)JSONUtil.toBean((String)resBody, CommonRes.class);
            throw new RuntimeException("CODE:" + commonRes.getCode() + "|MSG:" + commonRes.getMsg());
        }
        log.info("OpenApiClient ok res: {}", (Object)resBody);
        OpenApiBody resBodyBean = (OpenApiBody)JSONUtil.toBean((String)resBody, OpenApiBody.class);
        if (StringUtils.isNotEmpty((CharSequence)salt)) {
            boolean verify = OpenApiUtil.verify(resBodyBean, this.thirdPubKey, resSign, salt);
            log.info("OpenApiClient verify: {}", (Object)verify);
            Validate.isTrue((boolean)verify, (String)"OpenApiClient verify sign error", (Object[])new Object[0]);
        }
        String decrypt = OpenApiUtil.decrypt(resBodyBean, this.sysPriKey);
        log.info("OpenApiClient decrypt: {}", (Object)decrypt);
        return (S)JSONUtil.toBean((String)decrypt, beanClass);
    }
}

