package com.primexpy.openapi.code;


import com.primexpy.openapi.pojo.OpenApiKeyPair;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

/**
 * RSA CODER
 *
 * @author primexpy
 */
public class RSACoder extends CommonCoder {

    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";


    public RSACoder() {
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = decodeBase64(privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey pKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(pKey);
        signature.update(data);
        return encodeBase64(signature.sign());
    }


    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pKey);
        signature.update(data);
        return signature.verify(decodeBase64(sign));
    }

    public static String decryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = decodeBase64(key);
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key pKey = factory.generatePrivate(encodedKeySpec);
        Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
        cipher.init(Cipher.DECRYPT_MODE, pKey);
        return new String(cipher.doFinal(decodeBase64(data)));
    }


    public static String decryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = decodeBase64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key pKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.DECRYPT_MODE, pKey);
        return new String(cipher.doFinal(decodeBase64(data)));
    }

    public static String encryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = decodeBase64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key pKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.ENCRYPT_MODE, pKey);
        byte[] encryptData = cipher.doFinal(data.getBytes());
        return encodeBase64(encryptData);
    }

    public static String encryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = decodeBase64(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key privateKey = keyFactory.generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.ENCRYPT_MODE, privateKey);
        byte[] encryptData = cipher.doFinal(data.getBytes());
        return encodeBase64(encryptData);
    }

    public static OpenApiKeyPair generatePrivateAndPublicKey() throws Exception {
        KeyPairGenerator senderKeyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        senderKeyPairGenerator.initialize(512);
        KeyPair keyPair = senderKeyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey) keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey) keyPair.getPrivate();
        return new OpenApiKeyPair(Base64.encodeBase64String(rsaPublicKey.getEncoded()), Base64.encodeBase64String(rsaPrivateKey.getEncoded()));
    }

}
