/*
 * Decompiled with CFR 0.152.
 */
package com.primexpy.openapi.code;

import com.primexpy.openapi.code.CommonCoder;
import com.primexpy.openapi.pojo.OpenApiKeyPair;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSACoder
extends CommonCoder {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";

    public static String sign(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey pKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(pKey);
        signature.update(data);
        return RSACoder.encodeBase64(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pKey);
        signature.update(data);
        return signature.verify(RSACoder.decodeBase64(sign));
    }

    public static String decryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(key);
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey pKey = factory.generatePrivate(encodedKeySpec);
        Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
        cipher.init(2, pKey);
        return new String(cipher.doFinal(RSACoder.decodeBase64(data)));
    }

    public static String decryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, pKey);
        return new String(cipher.doFinal(RSACoder.decodeBase64(data)));
    }

    public static String encryptByPublicKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, pKey);
        byte[] encryptData = cipher.doFinal(data.getBytes());
        return RSACoder.encodeBase64(encryptData);
    }

    public static String encryptByPrivateKey(String data, String key) throws Exception {
        byte[] keyBytes = RSACoder.decodeBase64(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        byte[] encryptData = cipher.doFinal(data.getBytes());
        return RSACoder.encodeBase64(encryptData);
    }

    public static OpenApiKeyPair generatePrivateAndPublicKey() throws Exception {
        KeyPairGenerator senderKeyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        senderKeyPairGenerator.initialize(512);
        KeyPair keyPair = senderKeyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        return new OpenApiKeyPair(Base64.encodeBase64String((byte[])rsaPublicKey.getEncoded()), Base64.encodeBase64String((byte[])rsaPrivateKey.getEncoded()));
    }
}

