/*
 * Decompiled with CFR 0.152.
 */
package com.primexpy.openapi.utils;

import com.primexpy.openapi.code.AESCoder;
import com.primexpy.openapi.code.RSACoder;
import com.primexpy.openapi.pojo.OpenApiBody;
import java.nio.charset.StandardCharsets;

public class OpenApiUtil {
    public static String sign(OpenApiBody openApiBody, String priKey, String salt) throws Exception {
        return RSACoder.sign(openApiBody.genSignStr(salt).getBytes(StandardCharsets.UTF_8), priKey);
    }

    public static boolean verify(OpenApiBody openApiBody, String pubKey, String sign, String salt) throws Exception {
        return RSACoder.verify(openApiBody.genSignStr(salt).getBytes(StandardCharsets.UTF_8), pubKey, sign);
    }

    public static OpenApiBody encrypt(String content, String pubKey) throws Exception {
        String key = AESCoder.getRandomKey();
        String enValue = AESCoder.aesEncrypt(content, key);
        String enKey = RSACoder.encryptByPublicKey(key, pubKey);
        return new OpenApiBody(enKey, enValue);
    }

    public static String decrypt(OpenApiBody openApiBody, String priKey) throws Exception {
        String enKey = openApiBody.getKey();
        String deKey = RSACoder.decryptByPrivateKey(enKey, priKey);
        String enValue = openApiBody.getValue();
        return AESCoder.aesDecrypt(enValue, deKey);
    }
}

