/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.emnus;

import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ColumnTypeEnums {
    DEFAULT("default_value"),
    VARCHAR("varchar"),
    TEXT("text"),
    BIGINT("bigint"),
    INT("int"),
    BIT("bit"),
    DATETIME("datetime"),
    DATE("date"),
    CHAR("char"),
    FLOAT("float"),
    DECIMAL("decimal"),
    TINYINT("tinyint"),
    NUMERIC("numeric"),
    TIME("time", null),
    LONGBLOB("longblob", null),
    NVARCHAR(null, "nvarchar"),
    NVARCHAR_MAX(null, "nvarchar(max)"),
    VARCHAR_MAX(null, "varchar(max)"),
    XML(null, "xml"),
    DATETIME2(null, "datetime2"),
    MONEY(null, "money"),
    VARBINARY(null, "varbinary"),
    VARBINARY_MAX(null, "varbinary(max)"),
    NCHAR(null, "nchar");

    private static final Logger log;
    private String mysql;
    private String sqlServer;

    private ColumnTypeEnums(String mysql, String sqlServer) {
        this.mysql = mysql;
        this.sqlServer = sqlServer;
    }

    private ColumnTypeEnums(String identical) {
        this.mysql = identical;
        this.sqlServer = identical;
    }

    public String getMysql() {
        return StrUtil.isBlank((CharSequence)this.mysql) ? VARCHAR.getMysql() : this.mysql;
    }

    public String getSqlServer() {
        return StrUtil.isBlank((CharSequence)this.sqlServer) ? NVARCHAR.getSqlServer() : this.sqlServer;
    }

    public String getMysql1() {
        return this.mysql;
    }

    public String getSqlServer1() {
        return this.sqlServer;
    }

    public static ColumnTypeEnums getMysqlByValue(String type) {
        for (ColumnTypeEnums types : ColumnTypeEnums.values()) {
            if (!Objects.equals(types.getMysql1(), type)) continue;
            return types;
        }
        return VARCHAR;
    }

    public static ColumnTypeEnums getSqlServerByValue(String type) {
        for (ColumnTypeEnums types : ColumnTypeEnums.values()) {
            if (!Objects.equals(types.getSqlServer1(), type)) continue;
            return types;
        }
        return NVARCHAR;
    }

    static {
        log = LoggerFactory.getLogger(ColumnTypeEnums.class);
    }
}

