/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.zerowsh.actable.dto.ConstraintInfo;
import io.gitee.zerowsh.actable.dto.TableColumnInfo;
import io.gitee.zerowsh.actable.dto.TableInfo;
import io.gitee.zerowsh.actable.emnus.ColumnTypeEnums;
import io.gitee.zerowsh.actable.emnus.JavaTypeTurnColumnTypeEnums;
import io.gitee.zerowsh.actable.emnus.ModelEnums;
import io.gitee.zerowsh.actable.emnus.SqlTypeEnums;
import io.gitee.zerowsh.actable.service.DatabaseService;
import io.gitee.zerowsh.actable.util.AcTableUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlImpl
implements DatabaseService {
    private static final Logger log = LoggerFactory.getLogger(MysqlImpl.class);
    public static final HashMap<SqlTypeEnums, String> MYSQL_EXECUTE_SQL = new HashMap<SqlTypeEnums, String>(){
        {
            this.put(SqlTypeEnums.GET_ALL_TABLE, "select table_name as name from information_schema.tables where table_schema = (select database())");
            this.put(SqlTypeEnums.DROP_TABLE, "drop table if exists `{}`");
            this.put(SqlTypeEnums.EXIST_TABLE, "select count(1) from information_schema.tables where table_name ='{}' and table_schema = (select database())");
            this.put(SqlTypeEnums.TABLE_STRUCTURE, "SELECT t.table_name tableName,t.table_comment tableComment, case when c.IS_NULLABLE='YES' then 1 else 0 end isNull, c.column_name columnName,c.column_comment columnComment,c.DATA_TYPE typeStr,c.COLUMN_DEFAULT defaultValue, case when c.NUMERIC_PRECISION !='' and  c.NUMERIC_PRECISION is not null then c.NUMERIC_PRECISION else  c.CHARACTER_MAXIMUM_LENGTH end length, case when c.NUMERIC_SCALE!='' and c.NUMERIC_SCALE is not null then c.NUMERIC_SCALE else c.DATETIME_PRECISION end decimalLength, case when c.column_key='PRI' then 1 else 0 end isKey,case when c.EXTRA='auto_increment' then 1 else 0 end isAutoIncrement FROM information_schema.columns c,information_schema.tables t WHERE c.table_name = t.table_name and c.table_name='{}' and c.table_schema = (select database()) AND t.table_schema = (SELECT DATABASE ())");
            this.put(SqlTypeEnums.CONSTRAINT_INFO, "select index_name constraintName ,GROUP_CONCAT(column_name order by column_name) constraintColumnName, case when non_unique=0 then case when index_name='PRIMARY' then 1 else 2 end else 3 end constraintFlag from information_schema.statistics where table_name = '{}' and table_schema = (select database()) GROUP BY constraintName,constraintFlag");
        }
    };

    @Override
    public List<String> getCreateTableSql(TableInfo tableInfo) {
        String[] columns;
        ArrayList<String> resultList = new ArrayList<String>();
        String tableName = tableInfo.getName();
        String comment = tableInfo.getComment();
        List<TableInfo.PropertyInfo> propertyInfoList = tableInfo.getPropertyInfoList();
        StringBuilder propertySb = new StringBuilder();
        for (TableInfo.PropertyInfo propertyInfo : propertyInfoList) {
            String columnName = propertyInfo.getColumnName();
            propertySb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{columnName}));
            MysqlImpl.splicingColumnInfo(propertySb, propertyInfo, tableName);
        }
        List<String> keyList = tableInfo.getKeyList();
        if (CollectionUtil.isNotEmpty(keyList)) {
            Iterator<TableInfo.IndexInfo> pkSb = new StringBuilder();
            for (String key : tableInfo.getKeyList()) {
                ((StringBuilder)((Object)pkSb)).append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{key})).append(",");
            }
            propertySb.append(StrUtil.format((CharSequence)" PRIMARY KEY ({}) ", (Object[])new Object[]{((StringBuilder)((Object)pkSb)).deleteCharAt(((StringBuilder)((Object)pkSb)).length() - 1)})).append(",");
        }
        for (TableInfo.UniqueInfo uniqueInfo : tableInfo.getUniqueInfoList()) {
            columns = uniqueInfo.getColumns();
            StringBuilder uniqueSb = new StringBuilder();
            for (String column : columns) {
                uniqueSb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{column})).append(",");
            }
            propertySb.append(StrUtil.format((CharSequence)" UNIQUE KEY `{}` ({}) ", (Object[])new Object[]{uniqueInfo.getValue(), uniqueSb.deleteCharAt(uniqueSb.length() - 1)})).append(",");
        }
        for (TableInfo.IndexInfo indexInfo : tableInfo.getIndexInfoList()) {
            columns = indexInfo.getColumns();
            StringBuilder indexSb = new StringBuilder();
            for (String column : columns) {
                indexSb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{column})).append(",");
            }
            propertySb.append(StrUtil.format((CharSequence)" KEY `{}` ({}) ", (Object[])new Object[]{indexInfo.getValue(), indexSb.deleteCharAt(indexSb.length() - 1)})).append(",");
        }
        String createTable = "CREATE TABLE {} ({})";
        if (StrUtil.isNotBlank((CharSequence)comment)) {
            createTable = createTable + StrUtil.format((CharSequence)" COMMENT='{}'", (Object[])new Object[]{comment});
        }
        resultList.add(StrUtil.format((CharSequence)createTable, (Object[])new Object[]{StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{tableName}), propertySb.deleteCharAt(propertySb.length() - 1)}));
        return resultList;
    }

    private static void createPk(Set<String> delConstraintSet, TableInfo tableInfo, boolean tableExistPk) {
        List<String> keyList = tableInfo.getKeyList();
        if (CollectionUtil.isNotEmpty(keyList) && (tableExistPk && delConstraintSet.contains(" DROP PRIMARY KEY") || !tableExistPk)) {
            StringBuilder keySb = new StringBuilder();
            for (String key : keyList) {
                keySb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{key})).append(",");
            }
            delConstraintSet.add(StrUtil.format((CharSequence)" ADD PRIMARY KEY ({})", (Object[])new Object[]{keySb.deleteCharAt(keySb.length() - 1)}));
        }
    }

    private static void createUk(Set<String> delConstraintSet, TableInfo tableInfo, List<ConstraintInfo> constraintInfoList) {
        List<TableInfo.UniqueInfo> uniqueInfoList = tableInfo.getUniqueInfoList();
        if (CollectionUtil.isNotEmpty(uniqueInfoList)) {
            for (TableInfo.UniqueInfo uniqueInfo : uniqueInfoList) {
                String value = uniqueInfo.getValue();
                String[] columns = uniqueInfo.getColumns();
                StringBuilder uniqueSb = new StringBuilder();
                if (MysqlImpl.handleUkList(constraintInfoList, uniqueInfo)) continue;
                for (String column : columns) {
                    uniqueSb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{column})).append(",");
                }
                delConstraintSet.add(StrUtil.format((CharSequence)" ADD UNIQUE INDEX  `{}` ({})", (Object[])new Object[]{value, uniqueSb.deleteCharAt(uniqueSb.length() - 1)}));
            }
        }
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 2)) continue;
            delConstraintSet.add(StrUtil.format((CharSequence)" DROP INDEX `{}`", (Object[])new Object[]{constraintInfo.getConstraintName()}));
        }
    }

    private static void createIdx(Set<String> delConstraintSet, TableInfo tableInfo, List<ConstraintInfo> constraintInfoList) {
        List<TableInfo.IndexInfo> indexInfoList = tableInfo.getIndexInfoList();
        if (CollectionUtil.isNotEmpty(indexInfoList)) {
            for (TableInfo.IndexInfo indexInfo : indexInfoList) {
                String value = indexInfo.getValue();
                String[] columns = indexInfo.getColumns();
                StringBuilder uniqueSb = new StringBuilder();
                if (MysqlImpl.handleIdxList(constraintInfoList, indexInfo)) continue;
                for (String column : columns) {
                    uniqueSb.append(StrUtil.format((CharSequence)"`{}`", (Object[])new Object[]{column})).append(",");
                }
                delConstraintSet.add(StrUtil.format((CharSequence)" ADD INDEX `{}` ({})", (Object[])new Object[]{value, uniqueSb.deleteCharAt(uniqueSb.length() - 1)}));
            }
        }
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 3)) continue;
            delConstraintSet.add(StrUtil.format((CharSequence)" DROP INDEX `{}`", (Object[])new Object[]{constraintInfo.getConstraintName()}));
        }
    }

    @Override
    public List<String> getUpdateTableSql(TableInfo tableInfo, List<TableColumnInfo> tableColumnInfoList, List<ConstraintInfo> constraintInfoList, List<ConstraintInfo> defaultInfoList, ModelEnums modelEnums) {
        String comment;
        boolean tableExistPk = false;
        if (CollectionUtil.isNotEmpty(constraintInfoList)) {
            tableExistPk = constraintInfoList.stream().anyMatch(constraintInfo -> Objects.equals(constraintInfo.getConstraintFlag(), 1));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        TableColumnInfo firstTableColumnInfo = tableColumnInfoList.get(0);
        String tableName = firstTableColumnInfo.getTableName();
        String string = comment = Objects.isNull(tableInfo.getComment()) ? "" : tableInfo.getComment();
        if (!Objects.equals(comment, firstTableColumnInfo.getTableComment())) {
            resultList.add(StrUtil.format((CharSequence)"ALTER TABLE `{}` COMMENT='{}'", (Object[])new Object[]{tableName, comment}));
        }
        List<TableInfo.PropertyInfo> propertyInfoList = tableInfo.getPropertyInfoList();
        LinkedHashSet<String> delConstraintSet = new LinkedHashSet<String>();
        StringBuilder updateColumnSql = new StringBuilder();
        for (TableColumnInfo tableColumnInfo : tableColumnInfoList) {
            boolean flag = false;
            Iterator<TableInfo.PropertyInfo> it = propertyInfoList.iterator();
            while (it.hasNext()) {
                String columnComment;
                TableInfo.PropertyInfo propertyInfo = it.next();
                if (!Objects.equals(tableColumnInfo.getColumnName(), propertyInfo.getColumnName())) continue;
                String type = propertyInfo.getType();
                String string2 = columnComment = Objects.isNull(propertyInfo.getColumnComment()) ? "" : propertyInfo.getColumnComment();
                boolean existUpdate = !Objects.equals(tableColumnInfo.getTypeStr(), type) || !Objects.equals(propertyInfo.getDefaultValue(), tableColumnInfo.getDefaultValue()) || tableColumnInfo.isNull() != (!propertyInfo.isKey() && !propertyInfo.isAutoIncrement() && propertyInfo.isNull()) || tableColumnInfo.isAutoIncrement() != propertyInfo.isAutoIncrement() || !Objects.equals(columnComment, tableColumnInfo.getColumnComment());
                int length = propertyInfo.getLength();
                int decimalLength = propertyInfo.getDecimalLength();
                ColumnTypeEnums typeEnum = ColumnTypeEnums.getMysqlByValue(type);
                switch (typeEnum) {
                    case VARCHAR: 
                    case CHAR: {
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getLength(), AcTableUtils.handleStrLength(length));
                        break;
                    }
                    case DATETIME: {
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getDecimalLength(), AcTableUtils.handleDateLength(length));
                        break;
                    }
                    case DECIMAL: 
                    case NUMERIC: {
                        if (decimalLength > length) {
                            decimalLength = length;
                        }
                        length = length > 65 || length < 0 ? 10 : length;
                        decimalLength = decimalLength > 65 || decimalLength < 0 ? 2 : decimalLength;
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getLength(), length) || !Objects.equals(tableColumnInfo.getDecimalLength(), decimalLength);
                        break;
                    }
                }
                if (propertyInfo.isKey() != tableColumnInfo.isKey() && tableExistPk) {
                    delConstraintSet.add(" DROP PRIMARY KEY");
                }
                if (existUpdate) {
                    StringBuilder propertySb = new StringBuilder();
                    MysqlImpl.splicingColumnInfo(propertySb, propertyInfo, tableName);
                    updateColumnSql.append(StrUtil.format((CharSequence)" MODIFY COLUMN `{}` {}", (Object[])new Object[]{propertyInfo.getColumnName(), propertySb}));
                }
                flag = true;
                it.remove();
                break;
            }
            if (!Objects.equals((Object)modelEnums, (Object)ModelEnums.ADD_OR_UPDATE_OR_DEL) || flag) continue;
            if (tableColumnInfo.isKey() && tableExistPk) {
                delConstraintSet.add(" DROP PRIMARY KEY");
            }
            updateColumnSql.append(StrUtil.format((CharSequence)" DROP COLUMN `{}`", (Object[])new Object[]{tableColumnInfo.getColumnName()})).append(",");
        }
        if (CollectionUtil.isNotEmpty(propertyInfoList)) {
            for (TableInfo.PropertyInfo propertyInfo : propertyInfoList) {
                if (propertyInfo.isKey() && tableExistPk) {
                    delConstraintSet.add(" DROP PRIMARY KEY");
                }
                StringBuilder propertySb = new StringBuilder();
                MysqlImpl.splicingColumnInfo(propertySb, propertyInfo, tableName);
                updateColumnSql.append(StrUtil.format((CharSequence)" ADD COLUMN `{}` {}", (Object[])new Object[]{propertyInfo.getColumnName(), propertySb}));
            }
        }
        MysqlImpl.createPk(delConstraintSet, tableInfo, tableExistPk);
        MysqlImpl.createUk(delConstraintSet, tableInfo, constraintInfoList);
        MysqlImpl.createIdx(delConstraintSet, tableInfo, constraintInfoList);
        if (CollectionUtil.isNotEmpty(delConstraintSet)) {
            for (String s : delConstraintSet) {
                updateColumnSql.append(s).append(",");
            }
        }
        if (updateColumnSql.length() > 0) {
            String resultSql = StrUtil.format((CharSequence)"ALTER TABLE `{}`", (Object[])new Object[]{tableName}) + updateColumnSql.deleteCharAt(updateColumnSql.length() - 1);
            resultList.add(resultSql);
        }
        return resultList;
    }

    @Override
    public String handleKeyword(String var) {
        if (var.startsWith("`") && var.endsWith("`")) {
            var = var.replace("`", "");
        }
        return var;
    }

    @Override
    public String javaTypeTurnColumnType(String fieldType, ColumnTypeEnums type) {
        return Objects.equals((Object)type, (Object)ColumnTypeEnums.DEFAULT) ? JavaTypeTurnColumnTypeEnums.getMysqlByValue(fieldType) : type.getMysql();
    }

    @Override
    public String getExecuteSql(SqlTypeEnums sqlTypeEnums) {
        return MYSQL_EXECUTE_SQL.get((Object)sqlTypeEnums);
    }

    private static void splicingColumnInfo(StringBuilder propertySb, TableInfo.PropertyInfo propertyInfo, String tableName) {
        MysqlImpl.splicingColumnType(propertySb, propertyInfo, tableName);
        if (propertyInfo.isNull() && !propertyInfo.isKey() && !propertyInfo.isAutoIncrement()) {
            propertySb.append(" NULL");
        } else {
            propertySb.append(" NOT NULL");
        }
        if (propertyInfo.isAutoIncrement()) {
            propertySb.append(" AUTO_INCREMENT");
        } else if (StrUtil.isNotBlank((CharSequence)propertyInfo.getDefaultValue())) {
            propertySb.append(" DEFAULT ").append(propertyInfo.getDefaultValue());
        }
        if (StrUtil.isNotBlank((CharSequence)propertyInfo.getColumnComment())) {
            propertySb.append(StrUtil.format((CharSequence)" COMMENT '{}'", (Object[])new Object[]{propertyInfo.getColumnComment()}));
        }
        propertySb.append(",");
    }

    private static void splicingColumnType(StringBuilder propertySb, TableInfo.PropertyInfo propertyInfo, String tableName) {
        String type = propertyInfo.getType();
        int length = propertyInfo.getLength();
        int decimalLength = propertyInfo.getDecimalLength();
        String columnName = propertyInfo.getColumnName();
        ColumnTypeEnums typeEnum = ColumnTypeEnums.getMysqlByValue(type);
        switch (typeEnum) {
            case VARCHAR: 
            case CHAR: 
            case DATETIME: 
            case BIGINT: {
                propertySb.append(" ").append(type).append("(");
                if (Objects.equals(type, ColumnTypeEnums.DATETIME.getSqlServer())) {
                    if (length > 6 || length < 0) {
                        log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 0});
                        propertySb.append(0);
                    } else {
                        propertySb.append(length);
                    }
                } else if (length < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 255});
                    propertySb.append(255);
                } else {
                    propertySb.append(length);
                }
                propertySb.append(")");
                break;
            }
            case DECIMAL: 
            case NUMERIC: {
                propertySb.append(" ").append(type).append("(");
                if (decimalLength > length) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7cbe\u5ea6\u957f\u5ea6 [{}] \u5927\u4e8e\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u7c7b\u578b\u957f\u5ea6 [{}]", new Object[]{tableName, columnName, type, decimalLength, length, length});
                    decimalLength = length;
                }
                if (length > 65 || length < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 10});
                    propertySb.append(10);
                } else {
                    propertySb.append(length);
                }
                if (decimalLength > 65 || decimalLength < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, decimalLength, 2});
                    propertySb.append(",").append(2);
                } else {
                    propertySb.append(",").append(decimalLength);
                }
                propertySb.append(")");
                break;
            }
            default: {
                propertySb.append(" ").append(type);
            }
        }
    }

    public static boolean handleUkList(List<ConstraintInfo> constraintInfoList, TableInfo.UniqueInfo uniqueInfo) {
        HashSet set = new HashSet();
        Iterator<ConstraintInfo> it = constraintInfoList.iterator();
        while (it.hasNext()) {
            ConstraintInfo constraintInfo = it.next();
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 2)) continue;
            Object[] columns = uniqueInfo.getColumns();
            String value = uniqueInfo.getValue();
            Arrays.sort(columns);
            if (!Objects.equals(StrUtil.join((CharSequence)",", (Object[])columns), constraintInfo.getConstraintColumnName()) && !Objects.equals(constraintInfo.getConstraintName(), value)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static boolean handleIdxList(List<ConstraintInfo> constraintInfoList, TableInfo.IndexInfo indexInfo) {
        Iterator<ConstraintInfo> it = constraintInfoList.iterator();
        while (it.hasNext()) {
            ConstraintInfo constraintInfo = it.next();
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 3)) continue;
            Object[] columns = indexInfo.getColumns();
            String value = indexInfo.getValue();
            Arrays.sort(columns);
            if (!Objects.equals(StrUtil.join((CharSequence)",", (Object[])columns), constraintInfo.getConstraintColumnName()) && !Objects.equals(constraintInfo.getConstraintName(), value)) continue;
            it.remove();
            return true;
        }
        return false;
    }
}

