/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import io.gitee.zerowsh.actable.dto.ConstraintInfo;
import io.gitee.zerowsh.actable.dto.TableColumnInfo;
import io.gitee.zerowsh.actable.dto.TableInfo;
import io.gitee.zerowsh.actable.emnus.ColumnTypeEnums;
import io.gitee.zerowsh.actable.emnus.JavaTypeTurnColumnTypeEnums;
import io.gitee.zerowsh.actable.emnus.ModelEnums;
import io.gitee.zerowsh.actable.emnus.SqlTypeEnums;
import io.gitee.zerowsh.actable.service.DatabaseService;
import io.gitee.zerowsh.actable.util.AcTableUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerImpl
implements DatabaseService {
    private static final Logger log = LoggerFactory.getLogger(SqlServerImpl.class);
    public static final HashMap<SqlTypeEnums, String> SQL_SERVER_EXECUTE_SQL = new HashMap<SqlTypeEnums, String>(){
        {
            this.put(SqlTypeEnums.GET_ALL_TABLE, "select name from sys.tables");
            this.put(SqlTypeEnums.DROP_TABLE, "drop table if exists [{}]");
            this.put(SqlTypeEnums.EXIST_TABLE, "SELECT count(1) FROM sys.all_objects WHERE object_id = OBJECT_ID('{}') AND type IN ('U')");
            this.put(SqlTypeEnums.TABLE_STRUCTURE, "SELECT d.name tableName,convert(nvarchar(255), f.value) tableComment,a.name columnName, case when COLUMNPROPERTY( a.id,a.name,'IsIdentity')=1 then  1 else 0 end isAutoIncrement, case when exists(SELECT 1 FROM sysobjects where xtype='PK' and parent_obj=a.id and name in ( SELECT name FROM sysindexes WHERE indid in( SELECT indid FROM sysindexkeys WHERE id = a.id AND colid=a.colid))) then 1 else 0 end isKey, b.name typeStr, COLUMNPROPERTY(a.id,a.name,'PRECISION') length, isnull(COLUMNPROPERTY(a.id,a.name,'Scale'),0) decimalLength, case when a.isnullable=1 then 1 else 0 end isNull,convert(nvarchar(255), e.text) defaultValue,convert(nvarchar(255), g.value) columnComment FROM syscolumns a left join systypes b on a.xusertype=b.xusertype inner join sysobjects d on a.id=d.id  and d.xtype='U' and  d.name<>'dtproperties' left join syscomments e on a.cdefault=e.id left join sys.extended_properties g on a.id=G.major_id and a.colid=g.minor_id left join sys.extended_properties f on d.id=f.major_id and f.minor_id=0 where d.name='{}'");
            this.put(SqlTypeEnums.CONSTRAINT_INFO, "WITH MO_Cook AS (SELECT  IDX.NAME AS constraintName, IDX.TYPE_DESC AS constraintType,COL.NAME AS constraintColumnName,case when IDX.IS_PRIMARY_KEY = 1 then 1 else case when        IDX.IS_UNIQUE_CONSTRAINT = 1 then 2 else 3 end end constraintFlag FROM  SYS.INDEXES IDX JOIN  SYS.INDEX_COLUMNS IDXCOL ON (IDX.OBJECT_ID = IDXCOL.OBJECT_ID AND IDX.INDEX_ID = IDXCOL.INDEX_ID) JOIN  SYS.TABLES TAB ON (IDX.OBJECT_ID = TAB.OBJECT_ID) JOIN  SYS.COLUMNS COL ON (IDX.OBJECT_ID = COL.OBJECT_ID AND IDXCOL.COLUMN_ID = COL.COLUMN_ID)  where  TAB.NAME='{}')  select constraintName,constraintType,constraintFlag,stuff((select ','+constraintColumnName from  MO_Cook    where c.constraintName=constraintName and c.constraintType=constraintType and c.constraintFlag=constraintFlag order by constraintColumnName  for xml path('')),1,1,'') as constraintColumnName  from MO_Cook c group by c.constraintName,c.constraintType,c.constraintFlag");
            this.put(SqlTypeEnums.DEFAULT_INFO, "select t.name constraintName,syscolumns.name constraintColumnName,4 constraintFlag from (SELECT sysobjects.name,sysobjects.id FROM sysobjects  where sysobjects.id IN ( SELECT syscolumns.cdefault FROM sysobjects INNER JOIN syscolumns ON sysobjects.Id= syscolumns.Id WHERE sysobjects.name= '{}' ))t  LEFT JOIN syscolumns ON t.Id= syscolumns.cdefault");
        }
    };

    @Override
    public List<String> getCreateTableSql(TableInfo tableInfo) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> addColumnCommentSqlList = new ArrayList<String>();
        String tableName = tableInfo.getName();
        String comment = tableInfo.getComment();
        List<TableInfo.PropertyInfo> propertyInfoList = tableInfo.getPropertyInfoList();
        StringBuilder propertySb = new StringBuilder();
        for (TableInfo.PropertyInfo propertyInfo : propertyInfoList) {
            String columnName = propertyInfo.getColumnName();
            String columnComment = propertyInfo.getColumnComment();
            propertySb.append(StrUtil.format((CharSequence)"[{}]", (Object[])new Object[]{columnName}));
            SqlServerImpl.splicingColumnInfo(propertySb, propertyInfo, tableName);
            if (!StrUtil.isNotBlank((CharSequence)columnComment)) continue;
            addColumnCommentSqlList.add(StrUtil.format((CharSequence)"EXEC sp_addextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}','COLUMN', N'{}'", (Object[])new Object[]{columnComment, tableName, columnName}));
        }
        resultList.add(StrUtil.format((CharSequence)"CREATE TABLE {} ({})", (Object[])new Object[]{StrUtil.format((CharSequence)"[{}]", (Object[])new Object[]{tableName}), propertySb.deleteCharAt(propertySb.length() - 1)}));
        if (StrUtil.isNotBlank((CharSequence)comment)) {
            resultList.add(StrUtil.format((CharSequence)"EXEC sp_addextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}'", (Object[])new Object[]{comment, tableName}));
        }
        resultList.addAll(addColumnCommentSqlList);
        SqlServerImpl.createPk(true, tableInfo.getKeyList(), tableName, resultList);
        SqlServerImpl.createUk(true, tableInfo.getUniqueInfoList(), tableName, resultList, null);
        SqlServerImpl.createIdx(true, tableInfo.getIndexInfoList(), tableName, resultList, null);
        return resultList;
    }

    private static void createPk(boolean flag, List<String> keyList, String tableName, List<String> resultList) {
        if (flag && CollectionUtil.isNotEmpty(keyList)) {
            StringBuilder keySb = new StringBuilder();
            for (String key : keyList) {
                keySb.append(StrUtil.format((CharSequence)"[{}]", (Object[])new Object[]{key})).append(",");
            }
            resultList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] ADD CONSTRAINT [{}] PRIMARY KEY CLUSTERED ({})", (Object[])new Object[]{tableName, "pk_" + tableName, keySb.deleteCharAt(keySb.length() - 1)}));
        }
    }

    private static void createUk(boolean flag, List<TableInfo.UniqueInfo> uniqueInfoList, String tableName, List<String> resultList, List<String> existUkNameList) {
        if (flag && CollectionUtil.isNotEmpty(uniqueInfoList)) {
            for (TableInfo.UniqueInfo uniqueInfo : uniqueInfoList) {
                String[] columns = uniqueInfo.getColumns();
                StringBuilder uniqueSb = new StringBuilder();
                for (String column : columns) {
                    uniqueSb.append(StrUtil.format((CharSequence)"[{}]", (Object[])new Object[]{column})).append(",");
                }
                if (!CollectionUtil.isEmpty(existUkNameList) && existUkNameList.contains(uniqueInfo.getValue())) continue;
                resultList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] add constraint [{}] unique ({})", (Object[])new Object[]{tableName, uniqueInfo.getValue(), uniqueSb.deleteCharAt(uniqueSb.length() - 1)}));
            }
        }
    }

    private static void createIdx(boolean flag, List<TableInfo.IndexInfo> indexInfoList, String tableName, List<String> resultList, List<String> existIdxNameList) {
        if (flag && CollectionUtil.isNotEmpty(indexInfoList)) {
            for (TableInfo.IndexInfo indexInfo : indexInfoList) {
                String[] columns = indexInfo.getColumns();
                StringBuilder indexSb = new StringBuilder();
                for (String column : columns) {
                    indexSb.append(StrUtil.format((CharSequence)"[{}]", (Object[])new Object[]{column})).append(",");
                }
                if (!CollectionUtil.isEmpty(existIdxNameList) && existIdxNameList.contains(indexInfo.getValue())) continue;
                resultList.add(StrUtil.format((CharSequence)"CREATE NONCLUSTERED INDEX [{}] ON [{}] ({})", (Object[])new Object[]{indexInfo.getValue(), tableName, indexSb.deleteCharAt(indexSb.length() - 1)}));
            }
        }
    }

    private static void handleTableComment(List<String> list, String comment, String tableComment, String tableName) {
        if (!Objects.equals(comment, tableComment)) {
            if (Objects.isNull(tableComment)) {
                list.add(StrUtil.format((CharSequence)"EXEC sp_addextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}'", (Object[])new Object[]{comment, tableName}));
            } else if (Objects.isNull(comment)) {
                list.add(StrUtil.format((CharSequence)"EXEC sys.sp_dropextendedproperty 'MS_Description',N'SCHEMA', N'dbo', N'TABLE', N'{}'", (Object[])new Object[]{tableName}));
            } else {
                list.add(StrUtil.format((CharSequence)"EXEC sp_updateextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}'", (Object[])new Object[]{comment, tableName}));
            }
        }
    }

    private static void handleColumnComment(TableColumnInfo tableColumnInfo, TableInfo.PropertyInfo propertyInfo, List<String> resultList, String tableName) {
        if (!Objects.equals(tableColumnInfo.getColumnComment(), propertyInfo.getColumnComment())) {
            if (Objects.isNull(tableColumnInfo.getColumnComment())) {
                resultList.add(StrUtil.format((CharSequence)"EXEC sp_addextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}','COLUMN', N'{}'", (Object[])new Object[]{propertyInfo.getColumnComment(), tableName, propertyInfo.getColumnName()}));
            } else if (Objects.isNull(propertyInfo.getColumnComment())) {
                resultList.add(StrUtil.format((CharSequence)"EXEC sys.sp_dropextendedproperty N'MS_Description',N'SCHEMA', N'dbo', N'TABLE', N'{}', N'COLUMN', N'{}'", (Object[])new Object[]{tableName, propertyInfo.getColumnName()}));
            } else {
                resultList.add(StrUtil.format((CharSequence)"EXEC sp_updateextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}','COLUMN', N'{}'", (Object[])new Object[]{propertyInfo.getColumnComment(), tableName, propertyInfo.getColumnName()}));
            }
        }
    }

    private static Map<String, Collection<String>> handleConstraint(String tableName, List<ConstraintInfo> constraintInfoList, List<ConstraintInfo> defaultInfoList, List<String> delUkList, List<String> delIdxList) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>(4);
        ArrayList<String> delPkConstraintSqlList = new ArrayList<String>();
        HashSet<String> delUkConstraintSqlSet = new HashSet<String>();
        HashSet<String> delIdxConstraintSqlSet = new HashSet<String>();
        ArrayList<String> delDefConstraintSqlList = new ArrayList<String>();
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            Integer constraintFlag = constraintInfo.getConstraintFlag();
            String constraintName = constraintInfo.getConstraintName();
            switch (constraintFlag) {
                case 1: {
                    delPkConstraintSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] DROP CONSTRAINT [{}]", (Object[])new Object[]{tableName, constraintName}));
                    break;
                }
                case 2: {
                    delUkList.add(constraintName);
                    delUkConstraintSqlSet.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] DROP CONSTRAINT [{}]", (Object[])new Object[]{tableName, constraintName}));
                    break;
                }
                case 3: {
                    delIdxList.add(constraintName);
                    delIdxConstraintSqlSet.add(StrUtil.format((CharSequence)"DROP INDEX [{}] ON [{}]", (Object[])new Object[]{constraintName, tableName}));
                    break;
                }
            }
        }
        for (ConstraintInfo defaultInfo : defaultInfoList) {
            delDefConstraintSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] DROP CONSTRAINT [{}]", (Object[])new Object[]{tableName, defaultInfo.getConstraintName()}));
        }
        map.put("del_pk_sql", delPkConstraintSqlList);
        map.put("del_uk_sql", delUkConstraintSqlSet);
        map.put("del_index_sql", delIdxConstraintSqlSet);
        map.put("del_df_sql", delDefConstraintSqlList);
        return map;
    }

    @Override
    public List<String> getUpdateTableSql(TableInfo tableInfo, List<TableColumnInfo> tableColumnInfoList, List<ConstraintInfo> constraintInfoList, List<ConstraintInfo> defaultInfoList, ModelEnums modelEnums) {
        ArrayList<String> resultList = new ArrayList<String>();
        TableColumnInfo firstTableColumnInfo = tableColumnInfoList.get(0);
        String tableName = firstTableColumnInfo.getTableName();
        ArrayList<ConstraintInfo> constraintInfoNewList = new ArrayList<ConstraintInfo>();
        ArrayList<ConstraintInfo> defaultInfoNewList = new ArrayList<ConstraintInfo>();
        SqlServerImpl.handleTableComment(resultList, tableInfo.getComment(), firstTableColumnInfo.getTableComment(), tableName);
        ArrayList<String> delColumnSqlList = new ArrayList<String>();
        ArrayList<String> addColumnSqlList = new ArrayList<String>();
        ArrayList<String> addColumnCommentSqlList = new ArrayList<String>();
        ArrayList<String> updateColumnSqlList = new ArrayList<String>();
        ArrayList<String> addColumnDefSqlList = new ArrayList<String>();
        List<TableInfo.PropertyInfo> propertyInfoList = tableInfo.getPropertyInfoList();
        boolean defFlag = false;
        boolean pkFlag = false;
        boolean idxFlag = false;
        boolean ukFlag = false;
        for (TableColumnInfo tableColumnInfo : tableColumnInfoList) {
            boolean flag = false;
            Iterator<TableInfo.PropertyInfo> it = propertyInfoList.iterator();
            while (it.hasNext()) {
                boolean typeNotExistUpdate;
                boolean judgeDef;
                Iterator<Object> propertyInfo = it.next();
                String type = ((TableInfo.PropertyInfo)((Object)propertyInfo)).getType();
                if (!Objects.equals(tableColumnInfo.getColumnName(), ((TableInfo.PropertyInfo)((Object)propertyInfo)).getColumnName())) continue;
                boolean defExistUpdate = !Objects.equals(((TableInfo.PropertyInfo)((Object)propertyInfo)).getDefaultValue(), tableColumnInfo.getDefaultValue()) && !Objects.equals("(" + ((TableInfo.PropertyInfo)((Object)propertyInfo)).getDefaultValue() + ")", tableColumnInfo.getDefaultValue()) && !Objects.equals("((" + ((TableInfo.PropertyInfo)((Object)propertyInfo)).getDefaultValue() + ")" + ")", tableColumnInfo.getDefaultValue());
                boolean bl = judgeDef = defExistUpdate || !Objects.equals(tableColumnInfo.getTypeStr(), type) && Objects.nonNull(tableColumnInfo.getDefaultValue());
                if (judgeDef) {
                    SqlServerImpl.addDelDefConstraintInfo(defaultInfoList, defaultInfoNewList, ((TableInfo.PropertyInfo)((Object)propertyInfo)).getColumnName());
                    defFlag = true;
                }
                boolean bl2 = typeNotExistUpdate = Objects.equals(tableColumnInfo.getTypeStr(), type) || type.contains("max") && tableColumnInfo.getLength() == -1 && (Objects.equals(tableColumnInfo.getTypeStr(), "varbinary") || Objects.equals(tableColumnInfo.getTypeStr(), "varchar") || Objects.equals(tableColumnInfo.getTypeStr(), "nvarchar"));
                boolean existUpdate = !typeNotExistUpdate || defExistUpdate || ((TableInfo.PropertyInfo)((Object)propertyInfo)).isKey() != tableColumnInfo.isKey() || tableColumnInfo.isNull() != (!((TableInfo.PropertyInfo)((Object)propertyInfo)).isKey() && !((TableInfo.PropertyInfo)((Object)propertyInfo)).isAutoIncrement() && ((TableInfo.PropertyInfo)((Object)propertyInfo)).isNull()) || tableColumnInfo.isAutoIncrement() != ((TableInfo.PropertyInfo)((Object)propertyInfo)).isAutoIncrement();
                int length = ((TableInfo.PropertyInfo)((Object)propertyInfo)).getLength();
                int decimalLength = ((TableInfo.PropertyInfo)((Object)propertyInfo)).getDecimalLength();
                ColumnTypeEnums typeEnum = ColumnTypeEnums.getSqlServerByValue(type);
                switch (typeEnum) {
                    case NVARCHAR: 
                    case VARCHAR: 
                    case NCHAR: 
                    case CHAR: {
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getLength(), AcTableUtils.handleStrLength(length));
                        break;
                    }
                    case DATETIME2: {
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getDecimalLength(), AcTableUtils.handleDateLength(length));
                        break;
                    }
                    case DECIMAL: 
                    case NUMERIC: {
                        if (decimalLength > length) {
                            decimalLength = length;
                        }
                        length = length > 38 || length < 0 ? 18 : length;
                        decimalLength = decimalLength > 38 || decimalLength < 0 ? 2 : decimalLength;
                        existUpdate = existUpdate || !Objects.equals(tableColumnInfo.getLength(), length) || !Objects.equals(tableColumnInfo.getDecimalLength(), decimalLength);
                        break;
                    }
                }
                if (existUpdate) {
                    if (tableColumnInfo.isAutoIncrement() && !((TableInfo.PropertyInfo)((Object)propertyInfo)).isAutoIncrement()) {
                        throw new RuntimeException(StrUtil.format((CharSequence)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u5c06\u81ea\u589e\u5b57\u6bb5\u6539\u6210\u975e\u81ea\u589e\uff0c\u8bf7\u624b\u52a8\u5220\u9664\u8be5\u5b57\u6bb5\u6216\u8005\u8c03\u6574\u5b9e\u4f53\u7c7b\uff01\uff01\uff01table={} column={}", (Object[])new Object[]{tableName, ((TableInfo.PropertyInfo)((Object)propertyInfo)).getColumnName()}));
                    }
                    if (((TableInfo.PropertyInfo)((Object)propertyInfo)).isKey() || tableColumnInfo.isKey()) {
                        pkFlag = true;
                    }
                    StringBuilder propertySb = new StringBuilder();
                    SqlServerImpl.splicingColumnInfo(propertySb, propertyInfo, tableName, true, addColumnDefSqlList);
                    updateColumnSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] ALTER COLUMN [{}] {}", (Object[])new Object[]{tableName, ((TableInfo.PropertyInfo)((Object)propertyInfo)).getColumnName(), propertySb.deleteCharAt(propertySb.length() - 1)}));
                }
                SqlServerImpl.handleColumnComment(tableColumnInfo, propertyInfo, resultList, tableName);
                flag = true;
                it.remove();
                break;
            }
            if (!Objects.equals((Object)modelEnums, (Object)ModelEnums.ADD_OR_UPDATE_OR_DEL) || flag) continue;
            if (tableColumnInfo.isKey()) {
                pkFlag = true;
            }
            if (SqlServerImpl.handleUkConstraintDatabase(tableColumnInfo.getColumnName(), constraintInfoList)) {
                ukFlag = true;
            }
            if (SqlServerImpl.handleIdxConstraintDatabase(tableColumnInfo.getColumnName(), constraintInfoList)) {
                idxFlag = true;
            }
            if (StrUtil.isNotBlank((CharSequence)tableColumnInfo.getDefaultValue())) {
                SqlServerImpl.addDelDefConstraintInfo(defaultInfoList, defaultInfoNewList, tableColumnInfo.getColumnName());
                defFlag = true;
            }
            delColumnSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] DROP COLUMN [{}]", (Object[])new Object[]{tableName, tableColumnInfo.getColumnName()}));
        }
        if (CollectionUtil.isNotEmpty(propertyInfoList)) {
            for (TableInfo.PropertyInfo propertyInfo : propertyInfoList) {
                if (propertyInfo.isKey()) {
                    pkFlag = true;
                }
                if (SqlServerImpl.handleUkConstraint(tableInfo, propertyInfo)) {
                    ukFlag = true;
                }
                if (SqlServerImpl.handleIdxConstraint(tableInfo, propertyInfo)) {
                    idxFlag = true;
                }
                StringBuilder propertySb = new StringBuilder();
                SqlServerImpl.splicingColumnInfo(propertySb, propertyInfo, tableName);
                if (StrUtil.isNotBlank((CharSequence)propertyInfo.getColumnComment())) {
                    addColumnCommentSqlList.add(StrUtil.format((CharSequence)"EXEC sp_addextendedproperty 'MS_Description', N'{}','SCHEMA', N'dbo','TABLE', N'{}','COLUMN', N'{}'", (Object[])new Object[]{propertyInfo.getColumnComment(), tableName, propertyInfo.getColumnName()}));
                }
                addColumnSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] ADD [{}] {}", (Object[])new Object[]{tableName, propertyInfo.getColumnName(), propertySb.deleteCharAt(propertySb.length() - 1)}));
            }
        }
        Set<String> uniqueInfoSet = SqlServerImpl.getPropertyUniqueSet(tableInfo.getUniqueInfoList());
        Set<String> indexInfoSet = SqlServerImpl.getPropertyIndexSet(tableInfo.getIndexInfoList());
        Set<String> uniqueInfoSet1 = SqlServerImpl.getDatabaseUniqueSet(constraintInfoList);
        Set<String> indexInfoSet1 = SqlServerImpl.getDatabaseIndexSet(constraintInfoList);
        block16: for (ConstraintInfo constraintInfo : constraintInfoList) {
            switch (constraintInfo.getConstraintFlag()) {
                case 2: {
                    if (uniqueInfoSet.contains(constraintInfo.getConstraintColumnName())) continue block16;
                    constraintInfoNewList.add(constraintInfo);
                    ukFlag = true;
                    continue block16;
                }
                case 3: {
                    if (indexInfoSet.contains(constraintInfo.getConstraintColumnName())) continue block16;
                    constraintInfoNewList.add(constraintInfo);
                    idxFlag = true;
                    continue block16;
                }
            }
            constraintInfoNewList.add(constraintInfo);
        }
        for (TableInfo.UniqueInfo uniqueInfo : tableInfo.getUniqueInfoList()) {
            Object[] columns = uniqueInfo.getColumns();
            if (!ArrayUtil.isNotEmpty((Object[])columns)) continue;
            Arrays.sort(columns);
            if (uniqueInfoSet1.contains(StrUtil.join((CharSequence)",", (Object[])columns))) continue;
            ukFlag = true;
            break;
        }
        for (TableInfo.IndexInfo indexInfo : tableInfo.getIndexInfoList()) {
            Object[] columns = indexInfo.getColumns();
            if (!ArrayUtil.isNotEmpty((Object[])columns)) continue;
            Arrays.sort(columns);
            if (indexInfoSet1.contains(StrUtil.join((CharSequence)",", (Object[])columns))) continue;
            idxFlag = true;
            break;
        }
        SqlServerImpl.excludePkConstraint(constraintInfoNewList, pkFlag);
        ArrayList<String> delUkList = new ArrayList<String>();
        ArrayList<String> delIdxList = new ArrayList<String>();
        ArrayList<String> exitUkList = new ArrayList<String>();
        ArrayList<String> exitIdxList = new ArrayList<String>();
        Map<String, Collection<String>> delConstraintSqlMap = SqlServerImpl.handleConstraint(tableName, constraintInfoNewList, defaultInfoNewList, delUkList, delIdxList);
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            switch (constraintInfo.getConstraintFlag()) {
                case 2: {
                    if (delUkList.contains(constraintInfo.getConstraintName())) break;
                    exitUkList.add(constraintInfo.getConstraintName());
                    break;
                }
                case 3: {
                    if (delIdxList.contains(constraintInfo.getConstraintName())) break;
                    exitIdxList.add(constraintInfo.getConstraintName());
                    break;
                }
            }
        }
        if (pkFlag) {
            resultList.addAll(delConstraintSqlMap.get("del_pk_sql"));
        }
        if (ukFlag) {
            resultList.addAll(delConstraintSqlMap.get("del_uk_sql"));
        }
        if (idxFlag) {
            resultList.addAll(delConstraintSqlMap.get("del_index_sql"));
        }
        if (defFlag) {
            resultList.addAll(delConstraintSqlMap.get("del_df_sql"));
        }
        resultList.addAll(delColumnSqlList);
        resultList.addAll(addColumnSqlList);
        resultList.addAll(addColumnCommentSqlList);
        resultList.addAll(updateColumnSqlList);
        SqlServerImpl.createPk(pkFlag, tableInfo.getKeyList(), tableName, resultList);
        SqlServerImpl.createUk(ukFlag, tableInfo.getUniqueInfoList(), tableName, resultList, exitUkList);
        SqlServerImpl.createIdx(idxFlag, tableInfo.getIndexInfoList(), tableName, resultList, exitIdxList);
        if (defFlag) {
            resultList.addAll(addColumnDefSqlList);
        }
        return resultList;
    }

    @Override
    public String handleKeyword(String var) {
        if (var.startsWith("[") && var.endsWith("]")) {
            var = var.replace("[", "").replace("]", "");
        }
        return var;
    }

    @Override
    public String javaTypeTurnColumnType(String fieldType, ColumnTypeEnums type) {
        return Objects.equals((Object)type, (Object)ColumnTypeEnums.DEFAULT) ? JavaTypeTurnColumnTypeEnums.getSqlServerByValue(fieldType) : type.getSqlServer();
    }

    @Override
    public String getExecuteSql(SqlTypeEnums sqlTypeEnums) {
        return SQL_SERVER_EXECUTE_SQL.get((Object)sqlTypeEnums);
    }

    public static void excludePkConstraint(List<ConstraintInfo> defaultInfoList, boolean pkFlag) {
        if (!pkFlag) {
            defaultInfoList.removeIf(constraintInfo -> Objects.equals(1, constraintInfo.getConstraintFlag()));
        }
    }

    public static void addDelDefConstraintInfo(List<ConstraintInfo> defaultInfoList, List<ConstraintInfo> defaultInfoNewList, String columnName) {
        for (ConstraintInfo constraintInfo : defaultInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintColumnName(), columnName)) continue;
            defaultInfoNewList.add(constraintInfo);
        }
    }

    public static Set<String> getPropertyUniqueSet(List<TableInfo.UniqueInfo> uniqueInfoList) {
        HashSet<String> set = new HashSet<String>();
        for (TableInfo.UniqueInfo uniqueInfo : uniqueInfoList) {
            Object[] columns = uniqueInfo.getColumns();
            if (!ArrayUtil.isNotEmpty((Object[])columns)) continue;
            Arrays.sort(columns);
            set.add(StrUtil.join((CharSequence)",", (Object[])columns));
        }
        return set;
    }

    public static Set<String> getDatabaseUniqueSet(List<ConstraintInfo> constraintInfoList) {
        HashSet<String> set = new HashSet<String>();
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 2)) continue;
            set.add(constraintInfo.getConstraintColumnName());
        }
        return set;
    }

    public static Set<String> getPropertyIndexSet(List<TableInfo.IndexInfo> indexInfoList) {
        HashSet<String> set = new HashSet<String>();
        for (TableInfo.IndexInfo indexInfo : indexInfoList) {
            Object[] columns = indexInfo.getColumns();
            if (!ArrayUtil.isNotEmpty((Object[])columns)) continue;
            Arrays.sort(columns);
            set.add(StrUtil.join((CharSequence)",", (Object[])columns));
        }
        return set;
    }

    public static Set<String> getDatabaseIndexSet(List<ConstraintInfo> constraintInfoList) {
        HashSet<String> set = new HashSet<String>();
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintFlag(), 3)) continue;
            set.add(constraintInfo.getConstraintColumnName());
        }
        return set;
    }

    private static boolean handleUkConstraint(TableInfo tableInfo, TableInfo.PropertyInfo propertyInfo) {
        List<TableInfo.UniqueInfo> uniqueInfoList = tableInfo.getUniqueInfoList();
        for (TableInfo.UniqueInfo uniqueInfo : uniqueInfoList) {
            String[] columns;
            for (String column : columns = uniqueInfo.getColumns()) {
                if (!Objects.equals(column, propertyInfo.getColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean handleIdxConstraint(TableInfo tableInfo, TableInfo.PropertyInfo propertyInfo) {
        List<TableInfo.IndexInfo> indexInfoList = tableInfo.getIndexInfoList();
        for (TableInfo.IndexInfo indexInfo : indexInfoList) {
            String[] columns;
            for (String column : columns = indexInfo.getColumns()) {
                if (!Objects.equals(column, propertyInfo.getColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean handleUkConstraintDatabase(String columnName, List<ConstraintInfo> constraintInfoList) {
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintColumnName(), columnName) || !Objects.equals(constraintInfo.getConstraintFlag(), 2)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleIdxConstraintDatabase(String columnName, List<ConstraintInfo> constraintInfoList) {
        for (ConstraintInfo constraintInfo : constraintInfoList) {
            if (!Objects.equals(constraintInfo.getConstraintColumnName(), columnName) || !Objects.equals(constraintInfo.getConstraintFlag(), 3)) continue;
            return true;
        }
        return false;
    }

    private static void splicingColumnInfo(StringBuilder propertySb, TableInfo.PropertyInfo propertyInfo, String tableName) {
        SqlServerImpl.splicingColumnInfo(propertySb, propertyInfo, tableName, false, null);
    }

    private static void splicingColumnInfo(StringBuilder propertySb, TableInfo.PropertyInfo propertyInfo, String tableName, boolean isUpdate, List<String> addColumnDefSqlList) {
        SqlServerImpl.splicingColumnType(propertySb, propertyInfo, tableName);
        if (propertyInfo.isAutoIncrement() && !isUpdate) {
            propertySb.append(" identity(1,1)");
        }
        if (StrUtil.isNotBlank((CharSequence)propertyInfo.getDefaultValue())) {
            if (isUpdate) {
                addColumnDefSqlList.add(StrUtil.format((CharSequence)"ALTER TABLE [{}] ADD DEFAULT {} FOR [{}]", (Object[])new Object[]{tableName, propertyInfo.getDefaultValue(), propertyInfo.getColumnName()}));
            } else {
                propertySb.append(" DEFAULT ").append(propertyInfo.getDefaultValue());
            }
        }
        if (propertyInfo.isNull() && !propertyInfo.isKey() && !propertyInfo.isAutoIncrement()) {
            propertySb.append(" NULL");
        } else {
            propertySb.append(" NOT NULL");
        }
        propertySb.append(",");
    }

    private static void splicingColumnType(StringBuilder propertySb, TableInfo.PropertyInfo propertyInfo, String tableName) {
        String type = propertyInfo.getType();
        int length = propertyInfo.getLength();
        int decimalLength = propertyInfo.getDecimalLength();
        String columnName = propertyInfo.getColumnName();
        ColumnTypeEnums typeEnum = ColumnTypeEnums.getSqlServerByValue(type);
        switch (typeEnum) {
            case NVARCHAR: 
            case VARCHAR: 
            case NCHAR: 
            case CHAR: 
            case DATETIME2: {
                propertySb.append(" ").append(type).append("(");
                if (Objects.equals(type, ColumnTypeEnums.DATETIME2.getSqlServer())) {
                    if (length > 7 || length < 0) {
                        log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 0});
                        propertySb.append(0);
                    } else {
                        propertySb.append(length);
                    }
                } else if (length < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 255});
                    propertySb.append(255);
                } else {
                    propertySb.append(length);
                }
                propertySb.append(")");
                break;
            }
            case DECIMAL: 
            case NUMERIC: {
                propertySb.append(" ").append(type).append("(");
                if (decimalLength > length) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7cbe\u5ea6\u957f\u5ea6 [{}] \u5927\u4e8e\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u7c7b\u578b\u957f\u5ea6 [{}]", new Object[]{tableName, columnName, type, decimalLength, length, length});
                    decimalLength = length;
                }
                if (length > 38 || length < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, length, 18});
                    propertySb.append(18);
                } else {
                    propertySb.append(length);
                }
                if (decimalLength > 38 || decimalLength < 0) {
                    log.warn("\u8868 [{}] \u5b57\u6bb5 [{}] {}\u7c7b\u578b\u957f\u5ea6 [{}] \u5b58\u5728\u95ee\u9898\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c [{}]", new Object[]{tableName, columnName, type, decimalLength, 2});
                    propertySb.append(",").append(2);
                } else {
                    propertySb.append(",").append(decimalLength);
                }
                propertySb.append(")");
                break;
            }
            default: {
                propertySb.append(" ").append(type);
            }
        }
    }
}

