/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.util;

import cn.hutool.core.util.StrUtil;
import io.gitee.zerowsh.actable.service.DatabaseService;
import io.gitee.zerowsh.actable.service.impl.MysqlImpl;
import io.gitee.zerowsh.actable.service.impl.SqlServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcTableUtils {
    private static final Logger log = LoggerFactory.getLogger(AcTableUtils.class);

    public static int handleStrLength(int length) {
        return length < 0 ? 255 : length;
    }

    public static int handleDateLength(int length) {
        return length > 7 || length < 0 ? 0 : length;
    }

    public static DatabaseService getDatabaseService(String databaseType) {
        switch (databaseType) {
            case "MySQL": {
                return new MysqlImpl();
            }
            case "Microsoft SQL Server": {
                return new SqlServerImpl();
            }
        }
        throw new RuntimeException(StrUtil.format((CharSequence)"\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301 databaseType={}", (Object[])new Object[]{databaseType}));
    }
}

