/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.gitee.zerowsh.actable.annotation.AcColumn;
import io.gitee.zerowsh.actable.annotation.AcTable;
import io.gitee.zerowsh.actable.annotation.ExcludeSuperField;
import io.gitee.zerowsh.actable.annotation.IgnoreTable;
import io.gitee.zerowsh.actable.annotation.Index;
import io.gitee.zerowsh.actable.annotation.Unique;
import io.gitee.zerowsh.actable.dto.TableInfo;
import io.gitee.zerowsh.actable.emnus.TurnEnums;
import io.gitee.zerowsh.actable.properties.AcTableProperties;
import io.gitee.zerowsh.actable.service.DatabaseService;
import io.gitee.zerowsh.actable.util.AcTableUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerEntityUtils {
    private static final Logger log = LoggerFactory.getLogger(HandlerEntityUtils.class);

    public static List<TableInfo> getTableInfoByEntityPackage(AcTableProperties acTableProperties, String databaseType) {
        DatabaseService databaseService = AcTableUtils.getDatabaseService(databaseType);
        String entityPackage = acTableProperties.getEntityPackage();
        TurnEnums turn = acTableProperties.getTurn();
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<String> tableList = new ArrayList<String>();
        for (String s : entityPackage.split(",")) {
            Set acTableClass = ClassUtil.scanPackageByAnnotation((String)s, AcTable.class);
            Set tableNameClass = ClassUtil.scanPackageByAnnotation((String)s, TableName.class);
            Set tableClass = ClassUtil.scanPackageByAnnotation((String)s, Table.class);
            HashSet tableSet = new HashSet();
            tableSet.addAll(acTableClass);
            tableSet.addAll(tableNameClass);
            tableSet.addAll(tableClass);
            for (Class cls : tableSet) {
                if (Objects.nonNull(cls.getAnnotation(IgnoreTable.class))) continue;
                TableInfo.TableInfoBuilder builder = TableInfo.builder();
                ArrayList<TableInfo.PropertyInfo> propertyInfoList = new ArrayList<TableInfo.PropertyInfo>();
                ArrayList<TableInfo.IndexInfo> indexInfoList = new ArrayList<TableInfo.IndexInfo>();
                ArrayList<TableInfo.UniqueInfo> uniqueInfoList = new ArrayList<TableInfo.UniqueInfo>();
                ArrayList<String> keyList = new ArrayList<String>();
                ArrayList<String> propertyList = new ArrayList<String>();
                AcTable acTable = cls.getAnnotation(AcTable.class);
                TableName tableNameAnn = cls.getAnnotation(TableName.class);
                Table tableAnn = cls.getAnnotation(Table.class);
                String tableName = null;
                String comment = "default_value";
                ApiModel apiModel = cls.getAnnotation(ApiModel.class);
                if (Objects.nonNull(acTable)) {
                    tableName = acTable.name();
                    comment = acTable.comment();
                }
                if (Objects.nonNull(apiModel)) {
                    comment = apiModel.value();
                }
                if (Objects.nonNull(tableNameAnn) && StrUtil.isBlank((CharSequence)tableName)) {
                    tableName = tableNameAnn.value();
                }
                if (Objects.nonNull(tableAnn) && StrUtil.isBlank((CharSequence)tableName)) {
                    tableName = tableAnn.name();
                }
                if (StrUtil.isBlank((CharSequence)tableName)) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"AcTable\u3001com.baomidou.mybatisplus.annotation.TableName\u3001javax.persistence.Table \u90fd\u6ca1\u8bbe\u7f6e\u8868\u540d\uff01\uff01\uff01", (Object[])new Object[0]));
                }
                if (tableList.contains(tableName)) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"[{}] \u8868\u540d\u91cd\u590d", (Object[])new Object[]{tableName}));
                }
                tableName = databaseService.handleKeyword(tableName);
                tableList.add(tableName);
                builder.name(tableName);
                builder.comment(HandlerEntityUtils.judgeIsNull(comment));
                HandlerEntityUtils.getFieldInfo(cls, propertyInfoList, indexInfoList, uniqueInfoList, propertyList, acTable, null, turn, acTableProperties, databaseService);
                if (CollectionUtil.isEmpty(propertyInfoList)) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"\u7c7b [{}] \u4e0d\u5b58\u5728\u5b57\u6bb5\u4fe1\u606f", (Object[])new Object[]{cls.getName()}));
                }
                Collections.sort(propertyInfoList, new Comparator<TableInfo.PropertyInfo>(){

                    @Override
                    public int compare(TableInfo.PropertyInfo o1, TableInfo.PropertyInfo o2) {
                        return o1.getOrder() - o2.getOrder();
                    }
                });
                for (TableInfo.PropertyInfo propertyInfo : propertyInfoList) {
                    if (!propertyInfo.isKey()) continue;
                    keyList.add(propertyInfo.getColumnName());
                }
                TableInfo tableInfo = builder.keyList(keyList).propertyInfoList(propertyInfoList).indexInfoList(indexInfoList).uniqueInfoList(uniqueInfoList).build();
                tableInfoList.add(tableInfo);
            }
        }
        return tableInfoList;
    }

    private static String judgeIsNull(String comment) {
        return Objects.equals(comment, "default_value") ? null : comment;
    }

    private static void getFieldInfo(Class<?> cls, List<TableInfo.PropertyInfo> propertyInfoList, List<TableInfo.IndexInfo> indexInfoList, List<TableInfo.UniqueInfo> uniqueInfoList, List<String> propertyList, AcTable acTable, ExcludeSuperField excludeSuperField, TurnEnums turn, AcTableProperties acTableProperties, DatabaseService databaseService) {
        for (Field field : cls.getDeclaredFields()) {
            Object[] objectArray;
            Unique unique;
            String columnComment;
            boolean isAutoIncrement;
            boolean isKey;
            String modifier;
            Object[] value;
            TableInfo.PropertyInfo.PropertyInfoBuilder propertyInfoBuilder = TableInfo.PropertyInfo.builder();
            String fieldName = field.getName();
            String columnName = null;
            if (Objects.nonNull(excludeSuperField) && ArrayUtil.isNotEmpty((Object[])(value = excludeSuperField.value())) && Arrays.asList(value).contains(fieldName) || (modifier = Modifier.toString(field.getModifiers())).contains("static") || modifier.contains("transient")) continue;
            AcColumn acColumn = field.getAnnotation(AcColumn.class);
            ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
            TableField tableField = field.getAnnotation(TableField.class);
            TableId tableId = field.getAnnotation(TableId.class);
            Column column = field.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            Transient transientAnn = field.getAnnotation(Transient.class);
            if (Objects.isNull(acColumn)) {
                if (Objects.nonNull(tableField) && !tableField.exist() || Objects.nonNull(transientAnn)) continue;
                if (Objects.nonNull(tableField)) {
                    columnName = tableField.value();
                }
                if (Objects.nonNull(column)) {
                    columnName = column.name();
                }
                String string = columnName = StrUtil.isBlank((CharSequence)columnName) ? HandlerEntityUtils.fieldNameTurnDatabaseColumn(fieldName, turn, acTable) : columnName;
                if (propertyList.contains(columnName)) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"[{}] \u5b57\u6bb5\u540d\u6216@Column name\u91cd\u590d", (Object[])new Object[]{fieldName}));
                }
                propertyList.add(columnName);
                isKey = Objects.nonNull(tableId) || Objects.nonNull(id);
                isAutoIncrement = Objects.nonNull(tableId) && Objects.equals(tableId.type(), IdType.AUTO) || Objects.nonNull(generatedValue) && Objects.equals(generatedValue.strategy(), GenerationType.IDENTITY);
                columnComment = Objects.nonNull(apiModelProperty) && StrUtil.isNotBlank((CharSequence)apiModelProperty.value()) ? apiModelProperty.value() : null;
                propertyInfoBuilder.columnName(columnName).columnComment(columnComment).decimalLength(0).isNull(true).isKey(isKey).isAutoIncrement(isAutoIncrement).length(255).type(databaseService.javaTypeTurnColumnType(field.getType().getName()));
            } else {
                if (Objects.nonNull(tableField) && !tableField.exist() || Objects.nonNull(transientAnn) || acColumn.exclude()) continue;
                columnName = acColumn.name();
                if (Objects.nonNull(tableField) && StrUtil.isBlank((CharSequence)columnName)) {
                    columnName = tableField.value();
                }
                if (Objects.nonNull(column) && StrUtil.isBlank((CharSequence)columnName)) {
                    columnName = column.name();
                }
                if (propertyList.contains(columnName = databaseService.handleKeyword(StrUtil.isBlank((CharSequence)columnName) ? HandlerEntityUtils.fieldNameTurnDatabaseColumn(fieldName, turn, acTable) : columnName))) {
                    throw new RuntimeException(StrUtil.format((CharSequence)"[{}] \u5b57\u6bb5\u540d\u6216@Column name\u91cd\u590d", (Object[])new Object[]{fieldName}));
                }
                propertyList.add(columnName);
                isKey = Objects.nonNull(tableId) || Objects.nonNull(id) || acColumn.isKey();
                isAutoIncrement = acColumn.isAutoIncrement() || Objects.nonNull(tableId) && Objects.equals(tableId.type(), IdType.AUTO) || Objects.nonNull(generatedValue) && Objects.equals(generatedValue.strategy(), GenerationType.IDENTITY);
                columnComment = Objects.nonNull(apiModelProperty) && StrUtil.isNotBlank((CharSequence)apiModelProperty.value()) ? apiModelProperty.value() : HandlerEntityUtils.judgeIsNull(acColumn.comment());
                propertyInfoBuilder.columnName(columnName).columnComment(columnComment).decimalLength(acColumn.decimalLength()).defaultValue(HandlerEntityUtils.judgeIsNull(acColumn.defaultValue())).isAutoIncrement(isAutoIncrement).isKey(isKey).order(acColumn.order()).isNull(acColumn.isNull()).length(acColumn.length()).type(databaseService.javaTypeTurnColumnType(field.getType().getName(), acColumn.type()));
            }
            propertyInfoList.add(propertyInfoBuilder.build());
            Index index = field.getAnnotation(Index.class);
            if (Objects.nonNull(index)) {
                Object[] objectArray2;
                Object[] columns = index.columns();
                String value2 = index.value();
                TableInfo.IndexInfo.IndexInfoBuilder indexInfoBuilder = TableInfo.IndexInfo.builder().value(StrUtil.isBlank((CharSequence)value2) ? "idx_" + fieldName : "idx_" + value2);
                if (ArrayUtil.isEmpty((Object[])columns)) {
                    String[] stringArray = new String[1];
                    objectArray2 = stringArray;
                    stringArray[0] = HandlerEntityUtils.fieldNameTurnDatabaseColumn(fieldName, turn, acTable);
                } else {
                    objectArray2 = columns;
                }
                TableInfo.IndexInfo indexInfo = indexInfoBuilder.columns((String[])objectArray2).build();
                indexInfoList.add(indexInfo);
            }
            if (!Objects.nonNull(unique = field.getAnnotation(Unique.class))) continue;
            Object[] columns = unique.columns();
            String value3 = unique.value();
            TableInfo.UniqueInfo.UniqueInfoBuilder uniqueInfoBuilder = TableInfo.UniqueInfo.builder().value(StrUtil.isBlank((CharSequence)value3) ? "uk_" + fieldName : "uk_" + value3);
            if (ArrayUtil.isEmpty((Object[])columns)) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = HandlerEntityUtils.fieldNameTurnDatabaseColumn(fieldName, turn, acTable);
            } else {
                objectArray = columns;
            }
            TableInfo.UniqueInfo uniqueInfo = uniqueInfoBuilder.columns((String[])objectArray).build();
            uniqueInfoList.add(uniqueInfo);
        }
        Class<?> superclass = cls.getSuperclass();
        if (Objects.isNull(superclass)) {
            return;
        }
        HandlerEntityUtils.getFieldInfo(superclass, propertyInfoList, indexInfoList, uniqueInfoList, propertyList, acTable, cls.getAnnotation(ExcludeSuperField.class), turn, acTableProperties, databaseService);
    }

    private static String fieldNameTurnDatabaseColumn(String fieldName, TurnEnums turn, AcTable acTable) {
        TurnEnums columnTurn;
        TurnEnums turnEnums = columnTurn = Objects.nonNull(acTable) ? acTable.turn() : TurnEnums.DEFAULT;
        if (Objects.equals((Object)columnTurn, (Object)TurnEnums.DEFAULT) ? turn == TurnEnums.SOURCE : columnTurn == TurnEnums.SOURCE) {
            return fieldName;
        }
        return StrUtil.toUnderlineCase((CharSequence)fieldName);
    }
}

