/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zerowsh.actable.util;

import cn.hutool.core.util.StrUtil;
import io.gitee.zerowsh.actable.dto.ConstraintInfo;
import io.gitee.zerowsh.actable.dto.TableColumnInfo;
import io.gitee.zerowsh.actable.util.IoUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);

    public static void executeSql(Connection conn, String sql, Object ... obj) throws SQLException {
        try (PreparedStatement ps = JdbcUtil.handlePrepareStatement(conn, sql, obj);){
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExist(Connection conn, String sql, Object ... obj) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block2: {
            boolean bl;
            ps = null;
            rs = null;
            try {
                ps = JdbcUtil.handlePrepareStatement(conn, sql, obj);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                bl = rs.getInt(1) > 0;
            }
            catch (Throwable throwable) {
                IoUtil.close(ps, rs);
                throw throwable;
            }
            IoUtil.close(ps, rs);
            return bl;
        }
        IoUtil.close(ps, rs);
        return false;
    }

    private static PreparedStatement handlePrepareStatement(Connection conn, String sql, Object ... obj) throws SQLException {
        String formatSql = StrUtil.format((CharSequence)sql, (Object[])obj);
        PreparedStatement ps = conn.prepareStatement(formatSql);
        log.info(formatSql);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TableColumnInfo> getTableColumnInfoList(Connection conn, String sql, Object ... obj) throws SQLException {
        ArrayList<TableColumnInfo> arrayList;
        ArrayList<TableColumnInfo> list = new ArrayList<TableColumnInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = JdbcUtil.handlePrepareStatement(conn, sql, obj);
            rs = ps.executeQuery();
            while (rs.next()) {
                TableColumnInfo tableColumnInfo = new TableColumnInfo();
                tableColumnInfo.setTableName(rs.getString("tableName"));
                tableColumnInfo.setTableComment(rs.getString("tableComment"));
                tableColumnInfo.setColumnName(rs.getString("columnName"));
                tableColumnInfo.setColumnComment(rs.getString("columnComment"));
                tableColumnInfo.setKey(rs.getBoolean("isKey"));
                tableColumnInfo.setTypeStr(rs.getString("typeStr"));
                tableColumnInfo.setLength(rs.getInt("length"));
                tableColumnInfo.setDecimalLength(rs.getInt("decimalLength"));
                tableColumnInfo.setNull(rs.getBoolean("isNull"));
                tableColumnInfo.setAutoIncrement(rs.getBoolean("isAutoIncrement"));
                tableColumnInfo.setDefaultValue(rs.getString("defaultValue"));
                list.add(tableColumnInfo);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            IoUtil.close(ps, rs);
            throw throwable;
        }
        IoUtil.close(ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConstraintInfo> getConstraintInfoList(Connection conn, String sql, Object ... obj) throws SQLException {
        ArrayList<ConstraintInfo> arrayList;
        ArrayList<ConstraintInfo> list = new ArrayList<ConstraintInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = JdbcUtil.handlePrepareStatement(conn, sql, obj);
            rs = ps.executeQuery();
            while (rs.next()) {
                ConstraintInfo constraintInfo = new ConstraintInfo();
                constraintInfo.setConstraintName(rs.getString("constraintName"));
                constraintInfo.setConstraintColumnName(rs.getString("constraintColumnName"));
                constraintInfo.setConstraintFlag(rs.getInt("constraintFlag"));
                list.add(constraintInfo);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            IoUtil.close(ps, rs);
            throw throwable;
        }
        IoUtil.close(ps, rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNameList(Connection conn, String sql, Object ... obj) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> list = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = JdbcUtil.handlePrepareStatement(conn, sql, obj);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("name"));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            IoUtil.close(ps, rs);
            throw throwable;
        }
        IoUtil.close(ps, rs);
        return arrayList;
    }
}

