/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.a2ap.core.client.A2AClient;
import io.github.a2ap.core.client.CardResolver;
import io.github.a2ap.core.exception.A2AError;
import io.github.a2ap.core.jsonrpc.JSONRPCError;
import io.github.a2ap.core.jsonrpc.JSONRPCRequest;
import io.github.a2ap.core.jsonrpc.JSONRPCResponse;
import io.github.a2ap.core.model.AgentCard;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.MessageSendParams;
import io.github.a2ap.core.model.SendMessageResponse;
import io.github.a2ap.core.model.SendStreamingMessageResponse;
import io.github.a2ap.core.model.Task;
import io.github.a2ap.core.model.TaskArtifactUpdateEvent;
import io.github.a2ap.core.model.TaskIdParams;
import io.github.a2ap.core.model.TaskPushNotificationConfig;
import io.github.a2ap.core.model.TaskQueryParams;
import io.github.a2ap.core.model.TaskStatusUpdateEvent;
import io.github.a2ap.core.util.JsonUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class DefaultA2AClient
implements A2AClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultA2AClient.class);
    private AgentCard agentCard;
    private final CardResolver cardResolver;
    private final HttpClient client;

    public DefaultA2AClient(CardResolver cardResolver) {
        this.cardResolver = cardResolver;
        this.agentCard = this.retrieveAgentCard();
        this.client = HttpClient.create();
    }

    public DefaultA2AClient(AgentCard agentCard) {
        this.agentCard = agentCard;
        this.client = HttpClient.create();
        this.cardResolver = null;
    }

    public DefaultA2AClient(AgentCard agentCard, CardResolver cardResolver) {
        this.agentCard = agentCard;
        this.cardResolver = cardResolver;
        this.client = HttpClient.create();
    }

    @Override
    public AgentCard agentCard() {
        if (this.agentCard != null) {
            return this.agentCard;
        }
        return this.retrieveAgentCard();
    }

    @Override
    public AgentCard retrieveAgentCard() {
        if (this.cardResolver != null) {
            AgentCard card;
            this.agentCard = card = this.cardResolver.resolveCard();
            return card;
        }
        log.warn("Retrieving agent card error due the card resolver is null, use the cache agent card {}", (Object)this.agentCard.getName());
        return this.agentCard;
    }

    @Override
    public SendMessageResponse sendMessage(MessageSendParams taskSendParams) throws A2AError {
        log.info("Sending message to {} with params: {}", (Object)this.agentCard.getName(), (Object)taskSendParams);
        try {
            JSONRPCResponse response;
            JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("message/send").params(taskSendParams).id(UUID.randomUUID().toString()).build();
            String responseData = (String)((HttpClient.RequestSender)this.client.headers(headers -> headers.add("Content-Type", (Object)"application/json")).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().aggregate().asString().block();
            if (responseData != null && (response = JsonUtil.fromJson(responseData, JSONRPCResponse.class)) != null) {
                String jsonStr;
                JsonNode jsonNode;
                if (response.getError() != null) {
                    JSONRPCError error = response.getError();
                    log.error("JSON-RPC error when sending message: code={}, message={}, data={}", new Object[]{error.getCode(), error.getMessage(), error.getData()});
                    throw new A2AError(error.getMessage(), error.getCode(), error.getData());
                }
                if (response.getResult() != null && (jsonNode = JsonUtil.fromJson(jsonStr = JsonUtil.toJson(response.getResult()))) != null && jsonNode.has("kind")) {
                    SendMessageResponse messageResponse = null;
                    String kind = jsonNode.get("kind").asText();
                    if ("message".equals(kind)) {
                        messageResponse = JsonUtil.fromJson(jsonStr, Message.class);
                    } else if ("task".equals(kind)) {
                        messageResponse = JsonUtil.fromJson(jsonStr, Task.class);
                    } else {
                        log.error("Unknown json-rpc kind: {}", (Object)kind);
                    }
                    if (messageResponse != null) {
                        log.info("Message sent successfully. Received response: {}", (Object)messageResponse);
                        return messageResponse;
                    }
                }
            }
            throw new A2AError("response data is null");
        }
        catch (Exception e) {
            log.error("Error sending message to {}: {}", new Object[]{this.agentCard.getName(), e.getMessage(), e});
            throw new A2AError(e.getMessage(), e);
        }
    }

    @Override
    public Flux<SendStreamingMessageResponse> sendMessageStream(MessageSendParams params) {
        log.info("Send stream message for {} from {}", (Object)params, (Object)this.agentCard.getName());
        JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("message/stream").params(params).id(UUID.randomUUID().toString()).build();
        return ((HttpClient.RequestSender)this.client.headers(headers -> {
            headers.add("Content-Type", (Object)"application/json");
            headers.add("Accept", (Object)"text/event-stream");
        }).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().asString().scan((Object)"", (accumulator, chunk) -> accumulator + chunk).flatMap(this::parseSseChunks).filter(Objects::nonNull).doOnError(e -> log.error("Error receiving streaming updates for {}: {}", new Object[]{params, e.getMessage(), e})).doOnComplete(() -> log.info("Message updates stream completed for {}.", (Object)params));
    }

    @Override
    public Task getTask(TaskQueryParams queryParams) {
        log.info("Getting task {} from {}", (Object)queryParams, (Object)this.agentCard.getName());
        try {
            JSONRPCResponse response;
            JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("tasks/get").params(queryParams).id(UUID.randomUUID().toString()).build();
            String responseData = (String)((HttpClient.RequestSender)this.client.headers(headers -> headers.add("Content-Type", (Object)"application/json")).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().aggregate().asString().block();
            if (responseData != null && (response = JsonUtil.fromJson(responseData, JSONRPCResponse.class)) != null) {
                if (response.getError() != null) {
                    log.error("JSON-RPC error when getting task: code={}, message={}, data={}", new Object[]{response.getError().getCode(), response.getError().getMessage(), response.getError().getData()});
                    return null;
                }
                if (response.getResult() != null) {
                    Task task = JsonUtil.fromJson(JsonUtil.toJson(response.getResult()), Task.class);
                    log.info("Successfully retrieved task {}: {}", (Object)queryParams, (Object)task);
                    return task;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error getting task {} from {}: {}", new Object[]{queryParams, this.agentCard.getName(), e.getMessage(), e});
            return null;
        }
    }

    @Override
    public Task cancelTask(TaskIdParams params) {
        log.info("Cancelling task {} on {}", (Object)params, (Object)this.agentCard.getName());
        try {
            JSONRPCResponse response;
            JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("tasks/cancel").params(params).id(UUID.randomUUID().toString()).build();
            String responseData = (String)((HttpClient.RequestSender)this.client.headers(headers -> headers.add("Content-Type", (Object)"application/json")).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().aggregate().asString().block();
            if (responseData != null && (response = JsonUtil.fromJson(responseData, JSONRPCResponse.class)) != null) {
                if (response.getError() != null) {
                    log.error("JSON-RPC error when cancelling task: code={}, message={}, data={}", new Object[]{response.getError().getCode(), response.getError().getMessage(), response.getError().getData()});
                    return null;
                }
                if (response.getResult() != null) {
                    Task task = JsonUtil.fromJson(JsonUtil.toJson(response.getResult()), Task.class);
                    log.info("Task {} cancelled successfully.", (Object)params);
                    return task;
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error cancelling task {} on {}: {}", new Object[]{params, this.agentCard.getName(), e.getMessage(), e});
            return null;
        }
    }

    @Override
    public TaskPushNotificationConfig setTaskPushNotification(TaskPushNotificationConfig params) {
        log.info("Setting push notification config for task {} on {}", (Object)params.getTaskId(), (Object)this.agentCard.getName());
        try {
            JSONRPCResponse response;
            JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("tasks/pushNotificationConfig/set").params(params).id(UUID.randomUUID().toString()).build();
            String responseData = (String)((HttpClient.RequestSender)this.client.headers(headers -> headers.add("Content-Type", (Object)"application/json")).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().aggregate().asString().block();
            if (responseData != null && (response = JsonUtil.fromJson(responseData, JSONRPCResponse.class)) != null) {
                if (response.getError() != null) {
                    log.error("JSON-RPC error when setting push notification config: code={}, message={}, data={}", new Object[]{response.getError().getCode(), response.getError().getMessage(), response.getError().getData()});
                    return null;
                }
                if (response.getResult() != null) {
                    return JsonUtil.fromJson(JsonUtil.toJson(response.getResult()), TaskPushNotificationConfig.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error setting push notification config for task {} on {}: {}", new Object[]{params.getTaskId(), this.agentCard.getName(), e.getMessage(), e});
            return null;
        }
    }

    @Override
    public TaskPushNotificationConfig getTaskPushNotification(TaskIdParams params) {
        log.info("Getting push notification config for task {} from {}", (Object)params.getId(), (Object)this.agentCard.getName());
        try {
            JSONRPCResponse response;
            JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("tasks/pushNotificationConfig/get").params(params).id(UUID.randomUUID().toString()).build();
            String responseData = (String)((HttpClient.RequestSender)this.client.headers(headers -> headers.add("Content-Type", (Object)"application/json")).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().aggregate().asString().block();
            if (responseData != null && (response = JsonUtil.fromJson(responseData, JSONRPCResponse.class)) != null) {
                if (response.getError() != null) {
                    log.error("JSON-RPC error when getting push notification config: code={}, message={}, data={}", new Object[]{response.getError().getCode(), response.getError().getMessage(), response.getError().getData()});
                    return null;
                }
                if (response.getResult() != null) {
                    return JsonUtil.fromJson(JsonUtil.toJson(response.getResult()), TaskPushNotificationConfig.class);
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error getting push notification config for task {} from {}: {}", new Object[]{params.getId(), this.agentCard.getName(), e.getMessage(), e});
            return null;
        }
    }

    @Override
    public Flux<SendStreamingMessageResponse> resubscribeTask(TaskQueryParams params) {
        log.info("Resubscribing to task updates for {} from {}", (Object)params.getTaskId(), (Object)this.agentCard.getName());
        JSONRPCRequest jsonRpcRequest = JSONRPCRequest.builder().method("tasks/resubscribe").params(Map.of("id", params.getTaskId())).id(UUID.randomUUID().toString()).build();
        return ((HttpClient.RequestSender)this.client.headers(headers -> {
            headers.add("Content-Type", (Object)"application/json");
            headers.add("Accept", (Object)"text/event-stream");
        }).post().uri(this.agentCard.getUrl())).send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])JsonUtil.toJson(jsonRpcRequest).getBytes(StandardCharsets.UTF_8)))).responseContent().asString().scan((Object)"", (accumulator, chunk) -> accumulator + chunk).flatMap(this::parseSseChunks).filter(Objects::nonNull).doOnError(e -> log.error("Error resubscribing to task updates for {}: {}", new Object[]{params.getTaskId(), e.getMessage(), e})).doOnComplete(() -> log.info("Task resubscription stream completed for {}.", (Object)params.getTaskId()));
    }

    @Override
    public Boolean supports(String capability) {
        if (this.agentCard == null) {
            this.agentCard = this.retrieveAgentCard();
        }
        if (this.agentCard == null || this.agentCard.getCapabilities() == null) {
            return false;
        }
        return switch (capability.toLowerCase()) {
            case "streaming" -> this.agentCard.getCapabilities().isStreaming();
            case "pushnotifications" -> this.agentCard.getCapabilities().isPushNotifications();
            default -> false;
        };
    }

    private SendStreamingMessageResponse parseServerSentEvent(String eventData) {
        if (StringUtil.isNullOrEmpty((String)eventData)) {
            return null;
        }
        try {
            String jsonData = this.extractJsonFromSSE(eventData);
            if (StringUtil.isNullOrEmpty((String)jsonData)) {
                return null;
            }
            JSONRPCResponse jsonRpcResponse = JsonUtil.fromJson(jsonData, JSONRPCResponse.class);
            if (jsonRpcResponse != null) {
                if (jsonRpcResponse.getError() != null) {
                    log.error("JSON-RPC error in server-sent event: code={}, message={}, data={}", new Object[]{jsonRpcResponse.getError().getCode(), jsonRpcResponse.getError().getMessage(), jsonRpcResponse.getError().getData()});
                    return null;
                }
                if (jsonRpcResponse.getResult() != null) {
                    String result = JsonUtil.toJson(jsonRpcResponse.getResult());
                    JsonNode jsonNode = JsonUtil.fromJson(result);
                    if (jsonNode != null && jsonNode.has("kind")) {
                        String kind = jsonNode.get("kind").asText();
                        if ("task".equals(kind)) {
                            return JsonUtil.fromJson(result, Task.class);
                        }
                        if ("message".equals(kind)) {
                            return JsonUtil.fromJson(result, Message.class);
                        }
                        if ("artifact-update".equals(kind)) {
                            return JsonUtil.fromJson(result, TaskArtifactUpdateEvent.class);
                        }
                        if ("status-update".equals(kind)) {
                            return JsonUtil.fromJson(result, TaskStatusUpdateEvent.class);
                        }
                        log.error("Unknown event kind: {}", (Object)kind);
                    } else {
                        log.error("Can not parse server-sent event: {}", (Object)jsonRpcResponse);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("Error parsing server-sent event: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Flux<SendStreamingMessageResponse> parseSseChunks(String accumulatedData) {
        if (StringUtil.isNullOrEmpty((String)accumulatedData)) {
            return Flux.empty();
        }
        ArrayList<SendStreamingMessageResponse> events = new ArrayList<SendStreamingMessageResponse>();
        SendStreamingMessageResponse response = this.parseServerSentEvent(accumulatedData);
        if (response != null) {
            events.add(response);
        }
        return Flux.fromIterable(events);
    }

    private String extractJsonFromSSE(String sseData) {
        if (StringUtil.isNullOrEmpty((String)sseData)) {
            return null;
        }
        String[] lines = sseData.split("\n");
        StringBuilder jsonData = new StringBuilder();
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("data:")) continue;
            String dataContent = line.substring(5);
            jsonData.append(dataContent);
        }
        String result = jsonData.toString().trim();
        return result.isEmpty() ? null : result;
    }
}

