/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JSONRPCRequest {
    @JsonProperty(value="jsonrpc")
    private final String jsonrpc = "2.0";
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="params")
    private Object params;
    @JsonProperty(value="id")
    private String id;

    public JSONRPCRequest() {
    }

    public JSONRPCRequest(String method, Object params, String id) {
        this.method = method;
        this.params = params;
        this.id = id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getJsonrpc() {
        return "2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Object getParams() {
        return this.params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONRPCRequest that = (JSONRPCRequest)o;
        return Objects.equals("2.0", that.jsonrpc) && Objects.equals(this.method, that.method) && Objects.equals(this.params, that.params) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash("2.0", this.method, this.params, this.id);
    }

    public String toString() {
        return "JSONRPCRequest{jsonrpc='2.0', method='" + this.method + "', params=" + this.params + ", id='" + this.id + "'}";
    }

    public static class Builder {
        private String method;
        private Object params;
        private String id;

        private Builder() {
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder params(Object params) {
            this.params = params;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public JSONRPCRequest build() {
            return new JSONRPCRequest(this.method, this.params, this.id);
        }
    }
}

