/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.a2ap.core.model.AgentAuthentication;
import io.github.a2ap.core.model.AgentCapabilities;
import io.github.a2ap.core.model.AgentProvider;
import io.github.a2ap.core.model.AgentSkill;
import io.github.a2ap.core.model.SecurityScheme;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AgentCard {
    @NotNull
    private String id;
    @NotNull
    private String name;
    private String description;
    @NotNull
    private String url;
    private AgentProvider provider;
    @NotNull
    private String version;
    private String documentationUrl;
    @NotNull
    private AgentCapabilities capabilities;
    private AgentAuthentication authentication;
    private Map<String, SecurityScheme> securitySchemes;
    private List<Map<String, List<String>>> security;
    private List<String> defaultInputModes = List.of("text");
    private List<String> defaultOutputModes = List.of("text");
    @NotNull
    private List<AgentSkill> skills;

    public AgentCard() {
    }

    public AgentCard(String id, String name, String description, String url, AgentProvider provider, String version, String documentationUrl, AgentCapabilities capabilities, AgentAuthentication authentication, Map<String, SecurityScheme> securitySchemes, List<Map<String, List<String>>> security, List<String> defaultInputModes, List<String> defaultOutputModes, List<AgentSkill> skills) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.url = url;
        this.provider = provider;
        this.version = version;
        this.documentationUrl = documentationUrl;
        this.capabilities = capabilities;
        this.authentication = authentication;
        this.securitySchemes = securitySchemes;
        this.security = security;
        this.defaultInputModes = defaultInputModes;
        this.defaultOutputModes = defaultOutputModes;
        this.skills = skills;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AgentProvider getProvider() {
        return this.provider;
    }

    public void setProvider(AgentProvider provider) {
        this.provider = provider;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public AgentCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(AgentCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public AgentAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AgentAuthentication authentication) {
        this.authentication = authentication;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<Map<String, List<String>>> security) {
        this.security = security;
    }

    public List<String> getDefaultInputModes() {
        return this.defaultInputModes;
    }

    public void setDefaultInputModes(List<String> defaultInputModes) {
        this.defaultInputModes = defaultInputModes;
    }

    public List<String> getDefaultOutputModes() {
        return this.defaultOutputModes;
    }

    public void setDefaultOutputModes(List<String> defaultOutputModes) {
        this.defaultOutputModes = defaultOutputModes;
    }

    public List<AgentSkill> getSkills() {
        return this.skills;
    }

    public void setSkills(List<AgentSkill> skills) {
        this.skills = skills;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentCard agentCard = (AgentCard)o;
        return Objects.equals(this.id, agentCard.id) && Objects.equals(this.name, agentCard.name) && Objects.equals(this.description, agentCard.description) && Objects.equals(this.url, agentCard.url) && Objects.equals(this.provider, agentCard.provider) && Objects.equals(this.version, agentCard.version) && Objects.equals(this.documentationUrl, agentCard.documentationUrl) && Objects.equals(this.capabilities, agentCard.capabilities) && Objects.equals(this.authentication, agentCard.authentication) && Objects.equals(this.securitySchemes, agentCard.securitySchemes) && Objects.equals(this.security, agentCard.security) && Objects.equals(this.defaultInputModes, agentCard.defaultInputModes) && Objects.equals(this.defaultOutputModes, agentCard.defaultOutputModes) && Objects.equals(this.skills, agentCard.skills);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.url, this.provider, this.version, this.documentationUrl, this.capabilities, this.authentication, this.securitySchemes, this.security, this.defaultInputModes, this.defaultOutputModes, this.skills);
    }

    public String toString() {
        return "AgentCard{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', url='" + this.url + "', provider=" + this.provider + ", version='" + this.version + "', documentationUrl='" + this.documentationUrl + "', capabilities=" + this.capabilities + ", authentication=" + this.authentication + ", securitySchemes=" + this.securitySchemes + ", security=" + this.security + ", defaultInputModes=" + this.defaultInputModes + ", defaultOutputModes=" + this.defaultOutputModes + ", skills=" + this.skills + "}";
    }

    public static class Builder {
        private String id;
        private String name;
        private String description;
        private String url;
        private AgentProvider provider;
        private String version;
        private String documentationUrl;
        private AgentCapabilities capabilities;
        private AgentAuthentication authentication;
        private Map<String, SecurityScheme> securitySchemes;
        private List<Map<String, List<String>>> security;
        private List<String> defaultInputModes = List.of("text");
        private List<String> defaultOutputModes = List.of("text");
        private List<AgentSkill> skills;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder provider(AgentProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public Builder capabilities(AgentCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder authentication(AgentAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder securitySchemes(Map<String, SecurityScheme> securitySchemes) {
            this.securitySchemes = securitySchemes;
            return this;
        }

        public Builder security(List<Map<String, List<String>>> security) {
            this.security = security;
            return this;
        }

        public Builder defaultInputModes(List<String> defaultInputModes) {
            this.defaultInputModes = defaultInputModes;
            return this;
        }

        public Builder defaultOutputModes(List<String> defaultOutputModes) {
            this.defaultOutputModes = defaultOutputModes;
            return this;
        }

        public Builder skills(List<AgentSkill> skills) {
            this.skills = skills;
            return this;
        }

        public AgentCard build() {
            return new AgentCard(this.id, this.name, this.description, this.url, this.provider, this.version, this.documentationUrl, this.capabilities, this.authentication, this.securitySchemes, this.security, this.defaultInputModes, this.defaultOutputModes, this.skills);
        }
    }
}

