/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AgentSkill {
    @NotNull
    @JsonProperty(value="id")
    private String id;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="tags")
    private List<String> tags;
    @JsonProperty(value="examples")
    private List<String> examples;
    @JsonProperty(value="inputModes")
    private List<String> inputModes;
    @JsonProperty(value="outputModes")
    private List<String> outputModes;

    public AgentSkill() {
    }

    public AgentSkill(String id, String name, String description, List<String> tags, List<String> examples, List<String> inputModes, List<String> outputModes) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.examples = examples;
        this.inputModes = inputModes;
        this.outputModes = outputModes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public void setExamples(List<String> examples) {
        this.examples = examples;
    }

    public List<String> getInputModes() {
        return this.inputModes;
    }

    public void setInputModes(List<String> inputModes) {
        this.inputModes = inputModes;
    }

    public List<String> getOutputModes() {
        return this.outputModes;
    }

    public void setOutputModes(List<String> outputModes) {
        this.outputModes = outputModes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentSkill that = (AgentSkill)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.examples, that.examples) && Objects.equals(this.inputModes, that.inputModes) && Objects.equals(this.outputModes, that.outputModes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.tags, this.examples, this.inputModes, this.outputModes);
    }

    public String toString() {
        return "AgentSkill{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', tags=" + this.tags + ", examples=" + this.examples + ", inputModes=" + this.inputModes + ", outputModes=" + this.outputModes + "}";
    }

    public static class Builder {
        private String id;
        private String name;
        private String description;
        private List<String> tags;
        private List<String> examples;
        private List<String> inputModes;
        private List<String> outputModes;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder examples(List<String> examples) {
            this.examples = examples;
            return this;
        }

        public Builder inputModes(List<String> inputModes) {
            this.inputModes = inputModes;
            return this;
        }

        public Builder outputModes(List<String> outputModes) {
            this.outputModes = outputModes;
            return this;
        }

        public AgentSkill build() {
            return new AgentSkill(this.id, this.name, this.description, this.tags, this.examples, this.inputModes, this.outputModes);
        }
    }
}

