/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.FileContent;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileWithUri
extends FileContent {
    @JsonProperty(value="uri")
    private String uri;

    public FileWithUri() {
    }

    public FileWithUri(String uri) {
        this.uri = uri;
    }

    public FileWithUri(String name, String mimeType, String uri) {
        super(name, mimeType);
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileWithUri that = (FileWithUri)o;
        return Objects.equals(this.uri, that.uri);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uri);
    }

    @Override
    public String toString() {
        return "FileWithUri{uri='" + this.uri + "', name='" + this.getName() + "', mimeType='" + this.getMimeType() + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String mimeType;
        private String uri;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public FileWithUri build() {
            return new FileWithUri(this.name, this.mimeType, this.uri);
        }
    }
}

