/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Part;
import io.github.a2ap.core.model.SendMessageResponse;
import io.github.a2ap.core.model.SendStreamingMessageResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message
implements SendMessageResponse,
SendStreamingMessageResponse {
    @JsonProperty(value="messageId")
    private String messageId;
    @JsonProperty(value="taskId")
    private String taskId;
    @JsonProperty(value="contextId")
    private String contextId;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="parts")
    private List<Part> parts;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;
    @JsonProperty(value="kind")
    private String kind = "message";

    public Message() {
    }

    public Message(String messageId, String taskId, String contextId, String role, List<Part> parts, Map<String, Object> metadata, String kind) {
        this.messageId = messageId;
        this.taskId = taskId;
        this.contextId = contextId;
        this.role = role;
        this.parts = parts;
        this.metadata = metadata;
        this.kind = kind;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.messageId, message.messageId) && Objects.equals(this.taskId, message.taskId) && Objects.equals(this.contextId, message.contextId) && Objects.equals(this.role, message.role) && Objects.equals(this.parts, message.parts) && Objects.equals(this.metadata, message.metadata) && Objects.equals(this.kind, message.kind);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.taskId, this.contextId, this.role, this.parts, this.metadata, this.kind);
    }

    public String toString() {
        return "Message{messageId='" + this.messageId + "', taskId='" + this.taskId + "', contextId='" + this.contextId + "', role='" + this.role + "', parts=" + this.parts + ", metadata=" + this.metadata + ", kind='" + this.kind + "'}";
    }

    public static class Builder {
        private String messageId;
        private String taskId;
        private String contextId;
        private String role;
        private List<Part> parts;
        private Map<String, Object> metadata;
        private String kind = "message";

        private Builder() {
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder parts(List<Part> parts) {
            this.parts = parts;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind == null ? "message" : kind;
            return this;
        }

        public Message build() {
            return new Message(this.messageId, this.taskId, this.contextId, this.role, this.parts, this.metadata, this.kind);
        }
    }
}

