/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.a2ap.core.model.MessageSendParams;
import io.github.a2ap.core.model.Task;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequestContext {
    private String taskId;
    private String contextId;
    private MessageSendParams request;
    private Task task;
    private List<Task> relatedTasks;

    public RequestContext() {
    }

    public RequestContext(String taskId, String contextId, MessageSendParams request, Task task, List<Task> relatedTasks) {
        this.taskId = taskId;
        this.contextId = contextId;
        this.request = request;
        this.task = task;
        this.relatedTasks = relatedTasks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public MessageSendParams getRequest() {
        return this.request;
    }

    public void setRequest(MessageSendParams request) {
        this.request = request;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public List<Task> getRelatedTasks() {
        return this.relatedTasks;
    }

    public void setRelatedTasks(List<Task> relatedTasks) {
        this.relatedTasks = relatedTasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestContext that = (RequestContext)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.contextId, that.contextId) && Objects.equals(this.request, that.request) && Objects.equals(this.task, that.task) && Objects.equals(this.relatedTasks, that.relatedTasks);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.contextId, this.request, this.task, this.relatedTasks);
    }

    public String toString() {
        return "RequestContext{taskId='" + this.taskId + "', contextId='" + this.contextId + "', request=" + this.request + ", task=" + this.task + ", relatedTasks=" + this.relatedTasks + "}";
    }

    public static class Builder {
        private String taskId;
        private String contextId;
        private MessageSendParams request;
        private Task task;
        private List<Task> relatedTasks;

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder request(MessageSendParams request) {
            this.request = request;
            return this;
        }

        public Builder task(Task task) {
            this.task = task;
            return this;
        }

        public Builder relatedTasks(List<Task> relatedTasks) {
            this.relatedTasks = relatedTasks;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.taskId, this.contextId, this.request, this.task, this.relatedTasks);
        }
    }
}

