/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.server.impl;

import io.github.a2ap.core.server.EventQueue;
import io.github.a2ap.core.server.QueueManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryQueueManager
implements QueueManager {
    private static final Logger log = LoggerFactory.getLogger(InMemoryQueueManager.class);
    private final ConcurrentMap<String, EventQueue> queues = new ConcurrentHashMap<String, EventQueue>();

    @Override
    public EventQueue create(String taskId) {
        log.debug("Creating EventQueue for task: {}", (Object)taskId);
        EventQueue newQueue = new EventQueue();
        EventQueue existingQueue = this.queues.putIfAbsent(taskId, newQueue);
        if (existingQueue != null) {
            log.debug("EventQueue already exists for task: {}", (Object)taskId);
        } else {
            log.debug("EventQueue created successfully for task: {}", (Object)taskId);
        }
        return newQueue;
    }

    @Override
    public EventQueue tap(String taskId) {
        log.debug("Tapping EventQueue for task: {}", (Object)taskId);
        EventQueue mainQueue = (EventQueue)this.queues.get(taskId);
        if (mainQueue == null) {
            log.warn("No EventQueue found for task: {}", (Object)taskId);
            return null;
        }
        EventQueue tappedQueue = mainQueue.tap();
        log.debug("Successfully tapped EventQueue for task: {}", (Object)taskId);
        return tappedQueue;
    }

    @Override
    public EventQueue get(String taskId) {
        log.debug("Getting EventQueue for task: {}", (Object)taskId);
        return (EventQueue)this.queues.get(taskId);
    }

    @Override
    public void remove(String taskId) {
        log.debug("Removing EventQueue for task: {}", (Object)taskId);
        EventQueue queue = (EventQueue)this.queues.remove(taskId);
        if (queue != null) {
            queue.close();
            log.debug("EventQueue removed and closed for task: {}", (Object)taskId);
        } else {
            log.warn("No EventQueue found to remove for task: {}", (Object)taskId);
        }
    }
}

