/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.server.impl;

import io.github.a2ap.core.model.Artifact;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.MessageSendParams;
import io.github.a2ap.core.model.Part;
import io.github.a2ap.core.model.RequestContext;
import io.github.a2ap.core.model.Task;
import io.github.a2ap.core.model.TaskArtifactUpdateEvent;
import io.github.a2ap.core.model.TaskPushNotificationConfig;
import io.github.a2ap.core.model.TaskState;
import io.github.a2ap.core.model.TaskStatus;
import io.github.a2ap.core.model.TaskStatusUpdateEvent;
import io.github.a2ap.core.model.TaskUpdate;
import io.github.a2ap.core.server.TaskManager;
import io.github.a2ap.core.server.TaskStore;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class InMemoryTaskManager
implements TaskManager {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskManager.class);
    private final TaskStore taskStore;
    private final Map<String, TaskPushNotificationConfig> notificationConfigMap = new ConcurrentHashMap<String, TaskPushNotificationConfig>();
    private final Map<String, Set<String>> contextTaskIdMap = new ConcurrentHashMap<String, Set<String>>();

    public InMemoryTaskManager(TaskStore taskStore) {
        this.taskStore = taskStore;
    }

    @Override
    public RequestContext loadOrCreateContext(MessageSendParams params) {
        String taskId = params.getMessage().getTaskId();
        taskId = taskId == null ? UUID.randomUUID().toString() : taskId;
        String contextId = params.getMessage().getContextId();
        contextId = contextId == null ? UUID.randomUUID().toString() : contextId;
        RequestContext.Builder contextBuilder = RequestContext.builder().taskId(taskId).contextId(contextId).request(params);
        Task currentTask = this.taskStore.load(taskId);
        if (currentTask == null) {
            currentTask = Task.builder().id(taskId).contextId(contextId).status(TaskStatus.builder().state(TaskState.SUBMITTED).timestamp(String.valueOf(Instant.now().toEpochMilli())).build()).metadata(params.getMetadata()).artifacts(new LinkedList<Artifact>()).history(new LinkedList<Message>()).build();
            log.info("Create new message task: {}", (Object)currentTask);
        } else {
            TaskState taskState = currentTask.getStatus().getState();
            if (taskState == TaskState.COMPLETED || taskState == TaskState.FAILED || taskState == TaskState.CANCELED || taskState == TaskState.REJECTED) {
                log.warn("Received message for task {} already in final state {}. Handling as new submission (keeping history)", (Object)taskId, (Object)taskState);
                taskStatusUpdate = TaskStatus.builder().state(TaskState.SUBMITTED).timestamp(String.valueOf(Instant.now().toEpochMilli())).build();
                this.applyTaskUpdate(currentTask, taskStatusUpdate).block();
            } else if (taskState == TaskState.INPUT_REQUIRED || taskState == TaskState.AUTH_REQUIRED) {
                log.info("Received message while {}, changing task {} state to 'working'", (Object)taskState, (Object)taskId);
                taskStatusUpdate = TaskStatus.builder().state(TaskState.WORKING).timestamp(String.valueOf(Instant.now().toEpochMilli())).build();
                this.applyTaskUpdate(currentTask, taskStatusUpdate).block();
            } else if (taskState == TaskState.WORKING) {
                log.info("Received message while task {} already 'working'. Proceeding.", (Object)taskId);
            } else {
                log.info("receiving task {} another message might be odd, but proceed.", (Object)taskId);
            }
        }
        contextBuilder.task(currentTask);
        Set relatedTaskIds = this.contextTaskIdMap.computeIfAbsent(contextId, k -> new HashSet());
        relatedTaskIds.add(taskId);
        String currentTaskId = taskId;
        List<Task> relatedTasksList = relatedTaskIds.stream().map(id -> {
            if (Objects.equals(id, currentTaskId)) {
                return null;
            }
            return this.taskStore.load((String)id);
        }).filter(Objects::nonNull).toList();
        contextBuilder.relatedTasks(relatedTasksList);
        return contextBuilder.build();
    }

    @Override
    public Task getTask(String taskId) {
        return this.taskStore.load(taskId);
    }

    @Override
    public Mono<Task> applyTaskUpdate(Task task, List<TaskUpdate> taskUpdates) {
        if (taskUpdates == null || taskUpdates.isEmpty()) {
            return Mono.just((Object)task);
        }
        for (TaskUpdate taskUpdate : taskUpdates) {
            if (taskUpdate instanceof TaskStatus) {
                TaskStatus taskStatus = (TaskStatus)taskUpdate;
                log.info("apply task {} updated with status {}", (Object)task.getId(), (Object)taskStatus);
                taskStatus.setTimestamp(String.valueOf(Instant.now().toEpochMilli()));
                task.setStatus(taskStatus);
                if (taskStatus.getMessage() == null || !Objects.equals(taskStatus.getMessage().getRole(), "agent")) continue;
                List<Object> history = task.getHistory() == null ? new LinkedList() : task.getHistory();
                history.add(taskStatus.getMessage());
                task.setHistory(history);
                continue;
            }
            if (taskUpdate instanceof Artifact) {
                Artifact artifact = (Artifact)taskUpdate;
                log.info("apply task {} updated with artifact {}", (Object)task.getId(), (Object)artifact);
                List<Artifact> artifacts = task.getArtifacts();
                if (artifacts == null) {
                    artifacts = new LinkedList<Artifact>();
                    task.setArtifacts(artifacts);
                }
                String artifactId = artifact.getArtifactId();
                int existingArtifactIndex = -1;
                for (int i = 0; i < artifacts.size(); ++i) {
                    Artifact art = artifacts.get(i);
                    if (art.getArtifactId() == null || !art.getArtifactId().equals(artifactId)) continue;
                    existingArtifactIndex = i;
                    break;
                }
                if (existingArtifactIndex != -1) {
                    log.debug("Replacing artifact at id {} for task {}", (Object)artifactId, (Object)task.getId());
                    artifacts.set(existingArtifactIndex, artifact);
                    continue;
                }
                log.debug("Adding new artifact with id {} for task {}", (Object)artifactId, (Object)task.getId());
                artifacts.add(artifact);
                continue;
            }
            log.error("Received taskUpdate {} but not a TaskUpdate {}", (Object)taskUpdate, taskUpdate.getClass());
        }
        this.taskStore.save(task);
        return Mono.just((Object)task);
    }

    @Override
    public Mono<Task> applyTaskUpdate(Task task, TaskUpdate update) {
        return this.applyTaskUpdate(task, Stream.of(update).collect(Collectors.toList()));
    }

    @Override
    public Mono<Task> applyStatusUpdate(Task task, TaskStatusUpdateEvent event) {
        log.info("apply task {} updated with status event {}", (Object)task.getId(), (Object)event);
        TaskStatus taskStatus = event.getStatus();
        if (taskStatus != null) {
            log.info("apply task {} updated with status {}", (Object)task.getId(), (Object)taskStatus);
            taskStatus.setTimestamp(String.valueOf(Instant.now().toEpochMilli()));
            task.setStatus(taskStatus);
            if (taskStatus.getMessage() != null && Objects.equals(taskStatus.getMessage().getRole(), "agent")) {
                List<Object> history = task.getHistory() == null ? new LinkedList() : task.getHistory();
                history.add(taskStatus.getMessage());
                task.setHistory(history);
            }
        } else {
            log.warn("Received TaskStatusUpdateEvent for task {} but status is null", (Object)task.getId());
        }
        this.taskStore.save(task);
        return Mono.just((Object)task);
    }

    @Override
    public Mono<Task> applyArtifactUpdate(Task task, TaskArtifactUpdateEvent event) {
        log.info("apply task {} updated with artifact event {}", (Object)task.getId(), (Object)event);
        List<Artifact> artifacts = task.getArtifacts();
        if (artifacts == null) {
            artifacts = new LinkedList<Artifact>();
            task.setArtifacts(artifacts);
        }
        Artifact newArtifactData = event.getArtifact();
        String artifactId = newArtifactData.getArtifactId();
        boolean appendParts = event.getAppend() != null ? event.getAppend() : false;
        Artifact existingArtifact = null;
        int existingArtifactIndex = -1;
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact art = artifacts.get(i);
            if (art.getArtifactId() == null || !art.getArtifactId().equals(artifactId)) continue;
            existingArtifact = art;
            existingArtifactIndex = i;
            break;
        }
        if (!appendParts) {
            if (existingArtifactIndex != -1) {
                log.debug("Replacing artifact at id {} for task {}", (Object)artifactId, (Object)task.getId());
                artifacts.set(existingArtifactIndex, newArtifactData);
            } else {
                log.debug("Adding new artifact with id {} for task {}", (Object)artifactId, (Object)task.getId());
                artifacts.add(newArtifactData);
            }
        } else if (existingArtifact != null) {
            log.debug("Appending parts to artifact id {} for task {}", (Object)artifactId, (Object)task.getId());
            if (existingArtifact.getParts() != null && newArtifactData.getParts() != null) {
                LinkedList<Part> parts = new LinkedList<Part>(existingArtifact.getParts());
                parts.addAll(newArtifactData.getParts());
                existingArtifact.setParts(parts);
            }
        } else {
            log.warn("Received append=true for nonexistent artifact id {} in task {}. Ignoring chunk.", (Object)artifactId, (Object)task.getId());
        }
        this.taskStore.save(task);
        return Mono.just((Object)task);
    }

    @Override
    public void registerTaskNotification(TaskPushNotificationConfig config) {
        this.notificationConfigMap.put(config.getTaskId(), config);
    }

    @Override
    public TaskPushNotificationConfig getTaskNotification(String taskId) {
        return this.notificationConfigMap.get(taskId);
    }
}

