/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest;

import com.cdancy.bitbucket.rest.BitbucketApi;
import com.cdancy.bitbucket.rest.BitbucketApiMetadata;
import com.cdancy.bitbucket.rest.BitbucketAuthentication;
import com.cdancy.bitbucket.rest.BitbucketUtils;
import com.cdancy.bitbucket.rest.auth.AuthenticationType;
import com.cdancy.bitbucket.rest.config.BitbucketAuthenticationModule;
import com.google.common.collect.Lists;
import com.google.inject.Module;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.javax.annotation.Nullable;

public final class BitbucketClient
implements Closeable {
    private final String endPoint;
    private final BitbucketAuthentication credentials;
    private final BitbucketApi bitbucketApi;
    private final Properties overrides;

    public BitbucketClient() {
        this(null, null, null, null);
    }

    public BitbucketClient(@Nullable String endPoint, @Nullable BitbucketAuthentication authentication, @Nullable Properties overrides, @Nullable List<Module> modules) {
        this.endPoint = endPoint != null ? endPoint : BitbucketUtils.inferEndpoint();
        this.credentials = authentication != null ? authentication : BitbucketUtils.inferAuthentication();
        this.overrides = this.mergeOverrides(overrides);
        this.bitbucketApi = this.createApi(this.endPoint, this.credentials, this.overrides, modules);
    }

    private BitbucketApi createApi(String endPoint, BitbucketAuthentication authentication, Properties overrides, List<Module> modules) {
        ArrayList allModules = Lists.newArrayList((Object[])new Module[]{new BitbucketAuthenticationModule(authentication)});
        if (modules != null) {
            allModules.addAll(modules);
        }
        return (BitbucketApi)ContextBuilder.newBuilder((ApiMetadata)new BitbucketApiMetadata.Builder().build()).endpoint(endPoint).modules((Iterable)allModules).overrides(overrides).buildApi(BitbucketApi.class);
    }

    private Properties mergeOverrides(Properties possibleOverrides) {
        Properties inferOverrides = BitbucketUtils.inferOverrides();
        if (possibleOverrides != null) {
            inferOverrides.putAll((Map<?, ?>)possibleOverrides);
        }
        return inferOverrides;
    }

    public String endPoint() {
        return this.endPoint;
    }

    @Deprecated
    public String credentials() {
        return this.authValue();
    }

    public Properties overrides() {
        return this.overrides;
    }

    public String authValue() {
        return this.credentials.authValue();
    }

    public AuthenticationType authType() {
        return this.credentials.authType();
    }

    public BitbucketApi api() {
        return this.bitbucketApi;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws IOException {
        if (this.api() != null) {
            this.api().close();
        }
    }

    public static class Builder {
        private String endPoint;
        private BitbucketAuthentication.Builder authBuilder;
        private Properties overrides;
        private List<Module> modules = Lists.newArrayList();

        public Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder credentials(String optionallyBase64EncodedCredentials) {
            this.authBuilder = BitbucketAuthentication.builder().credentials(optionallyBase64EncodedCredentials);
            return this;
        }

        public Builder token(String token) {
            this.authBuilder = BitbucketAuthentication.builder().token(token);
            return this;
        }

        public Builder overrides(Properties overrides) {
            this.overrides = overrides;
            return this;
        }

        public Builder modules(Module ... modules) {
            this.modules.addAll(Arrays.asList(modules));
            return this;
        }

        public BitbucketClient build() {
            BitbucketAuthentication authentication = this.authBuilder != null ? this.authBuilder.build() : null;
            return new BitbucketClient(this.endPoint, authentication, this.overrides, this.modules);
        }
    }
}

