/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.domain.insights;

import com.cdancy.bitbucket.rest.domain.insights.AutoValue_InsightReportData;
import com.cdancy.bitbucket.rest.domain.insights.InsightReportDataLink;
import com.google.auto.value.AutoValue;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class InsightReportData {
    public abstract String title();

    public abstract DataType type();

    public abstract Object value();

    @SerializedNames(value={"title", "type", "value"})
    private static InsightReportData create(String title, DataType type, Object value) {
        return new AutoValue_InsightReportData(title, type, value);
    }

    public static InsightReportData createBoolean(String title, boolean value) {
        return InsightReportData.create(title, DataType.BOOLEAN, value);
    }

    public static InsightReportData createDate(String title, LocalDate value) {
        return InsightReportData.createDate(title, value.atStartOfDay());
    }

    public static InsightReportData createDate(String title, LocalDateTime value) {
        long epochMilli = value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return InsightReportData.createDate(title, epochMilli);
    }

    public static InsightReportData createDate(String title, long epochMilli) {
        return InsightReportData.create(title, DataType.DATE, epochMilli);
    }

    public static InsightReportData createDuration(String title, Duration duration) {
        return InsightReportData.create(title, DataType.DURATION, duration.toMillis());
    }

    public static InsightReportData createDuration(String title, long millis) {
        return InsightReportData.create(title, DataType.DURATION, millis);
    }

    public static InsightReportData createLink(String title, String href) {
        return InsightReportData.createLink(title, href, href);
    }

    public static InsightReportData createLink(String title, String href, String linkText) {
        InsightReportDataLink link = InsightReportDataLink.create(linkText, href);
        return InsightReportData.create(title, DataType.LINK, link);
    }

    public static InsightReportData createNumber(String title, long number) {
        return InsightReportData.create(title, DataType.NUMBER, number);
    }

    public static InsightReportData createPercentage(String title, byte percentage) {
        return InsightReportData.create(title, DataType.PERCENTAGE, percentage);
    }

    public static InsightReportData createText(String title, String text) {
        return InsightReportData.create(title, DataType.TEXT, text);
    }

    public static enum DataType {
        BOOLEAN,
        DATE,
        DURATION,
        LINK,
        NUMBER,
        PERCENTAGE,
        TEXT;

    }
}

