/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.admin.UserPage;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.pullrequest.User;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/admin")
public interface AdminApi {
    @Named(value="admin:list-user-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.4/bitbucket-rest.html#idm46478323815824"})
    @Consumes(value={"application/json"})
    @Path(value="/groups/more-members")
    @Fallback(value=BitbucketFallbacks.UserPageOnError.class)
    @GET
    public UserPage listUsersByGroup(@QueryParam(value="context") String var1, @Nullable @QueryParam(value="filter") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="admin:list-users")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45588158982432"})
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @Fallback(value=BitbucketFallbacks.UserPageOnError.class)
    @GET
    public UserPage listUsers(@Nullable @QueryParam(value="filter") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);

    @Named(value="admin:create-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm46358291368432"})
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus createUser(@QueryParam(value="name") String var1, @QueryParam(value="password") String var2, @QueryParam(value="displayName") String var3, @QueryParam(value="emailAddress") String var4, @Nullable @QueryParam(value="addToDefaultGroup") Boolean var5, @Nullable @QueryParam(value="notify") String var6);

    @Named(value="admin:delete-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm46358291356736"})
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @Fallback(value=BitbucketFallbacks.UserOnError.class)
    @DELETE
    public User deleteUser(@QueryParam(value="name") String var1);
}

