/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.build.StatusPage;
import com.cdancy.bitbucket.rest.domain.build.Summary;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateBuildStatus;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/build-status/{jclouds.api-version}")
public interface BuildStatusApi {
    @Named(value="build-status:status")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.4/bitbucket-build-rest.html#idm44911111531152"})
    @Consumes(value={"application/json"})
    @Path(value="/commits/{commitId}")
    @Fallback(value=BitbucketFallbacks.StatusPageOnError.class)
    @GET
    public StatusPage status(@PathParam(value="commitId") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);

    @Named(value="build-status:add")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.4/bitbucket-build-rest.html#idm44911111500128"})
    @Consumes(value={"application/json"})
    @Path(value="/commits/{commitId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus add(@PathParam(value="commitId") String var1, @BinderParam(value=BindToJsonPayload.class) CreateBuildStatus var2);

    @Named(value="build-status:summary")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.4/bitbucket-build-rest.html#idm44911111484336"})
    @Consumes(value={"application/json"})
    @Path(value="/commits/stats/{commitId}")
    @GET
    public Summary summary(@PathParam(value="commitId") String var1);
}

