/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.commit.Commit;
import com.cdancy.bitbucket.rest.domain.commit.CommitPage;
import com.cdancy.bitbucket.rest.domain.pullrequest.ChangePage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface CommitsApi {
    @Named(value="commits:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888279116176"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/commits/{commitId}")
    @Fallback(value=BitbucketFallbacks.CommitOnError.class)
    @GET
    public Commit get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @Nullable @QueryParam(value="path") String var4);

    @Named(value="commits:list-changes")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm46478324982720"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/commits/{commitId}/changes")
    @Fallback(value=BitbucketFallbacks.ChangePageOnError.class)
    @GET
    public ChangePage listChanges(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @Nullable @QueryParam(value="limit") Integer var4, @Nullable @QueryParam(value="start") Integer var5);

    @Named(value="commits:list")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm140236729804608"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/commits")
    @Fallback(value=BitbucketFallbacks.CommitPageOnError.class)
    @GET
    public CommitPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="withCounts") Boolean var3, @Nullable @QueryParam(value="followRenames") Boolean var4, @Nullable @QueryParam(value="ignoreMissing") Boolean var5, @Nullable @QueryParam(value="merges") String var6, @Nullable @QueryParam(value="path") String var7, @Nullable @QueryParam(value="since") String var8, @Nullable @QueryParam(value="until") String var9, @Nullable @QueryParam(value="limit") Integer var10, @Nullable @QueryParam(value="start") Integer var11);
}

