/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.binders.BindHookSettingsToPayload;
import com.cdancy.bitbucket.rest.domain.repository.Hook;
import com.cdancy.bitbucket.rest.domain.repository.HookPage;
import com.cdancy.bitbucket.rest.domain.repository.HookSettings;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.parsers.HookSettingsParser;
import com.google.inject.name.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface HookApi {
    @Named(value="hook:list-hooks")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.1/bitbucket-rest.html#idm45993794419936"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks")
    @Fallback(value=BitbucketFallbacks.HookPageOnError.class)
    @GET
    public HookPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="hook:get-hook")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.1/bitbucket-rest.html#idm45993794409760"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks/{hookKey}")
    @Fallback(value=BitbucketFallbacks.HookOnError.class)
    @GET
    public Hook get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="hookKey") String var3);

    @Named(value="hook:update-hook-settings")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.0.1/bitbucket-rest.html#idm45993794444512"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks/{hookKey}/settings")
    @Fallback(value=BitbucketFallbacks.HookSettingsOnError.class)
    @ResponseParser(value=HookSettingsParser.class)
    @PUT
    public HookSettings update(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="hookKey") String var3, @BinderParam(value=BindHookSettingsToPayload.class) HookSettings var4);

    @Named(value="hook:get-hook-settings")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.0.1/bitbucket-rest.html#idm45993794444512"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks/{hookKey}/settings")
    @Fallback(value=BitbucketFallbacks.HookSettingsOnError.class)
    @ResponseParser(value=HookSettingsParser.class)
    @GET
    public HookSettings settings(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="hookKey") String var3);

    @Named(value="hook:enable-hook")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.1/bitbucket-rest.html#idm45993794409760"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks/{hookKey}/enabled")
    @Fallback(value=BitbucketFallbacks.HookOnError.class)
    @PUT
    public Hook enable(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="hookKey") String var3);

    @Named(value="hook:disable-hook")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.1/bitbucket-rest.html#idm45993794409760"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/settings/hooks/{hookKey}/enabled")
    @Fallback(value=BitbucketFallbacks.HookOnError.class)
    @DELETE
    public Hook disable(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="hookKey") String var3);
}

