/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.insights.Annotation;
import com.cdancy.bitbucket.rest.domain.insights.AnnotationsResponse;
import com.cdancy.bitbucket.rest.domain.insights.InsightReport;
import com.cdancy.bitbucket.rest.domain.insights.InsightReportPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateAnnotations;
import com.cdancy.bitbucket.rest.options.CreateInsightReport;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/insights/{jclouds.api-version}")
public interface InsightsApi {
    @Named(value="insights:get-annotations")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp2"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/annotations")
    @Fallback(value=BitbucketFallbacks.AnnotationsResponseOnError.class)
    @GET
    public AnnotationsResponse listAnnotations(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @Nullable @QueryParam(value="externalId") String var4, @Nullable @QueryParam(value="path") String var5, @Nullable @QueryParam(value="severity") String var6, @Nullable @QueryParam(value="type") String var7);

    @Named(value="insights:get-reports")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp4"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports")
    @Fallback(value=BitbucketFallbacks.InsightReportPageOnError.class)
    @GET
    public InsightReportPage listReports(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @Nullable @QueryParam(value="limit") int var4, @Nullable @QueryParam(value="start") int var5);

    @Named(value="insights:get-report")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp7"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}")
    @Fallback(value=BitbucketFallbacks.InsightReportOnError.class)
    @GET
    public InsightReport getReport(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4);

    @Named(value="insights:create-report")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp9"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}")
    @Fallback(value=BitbucketFallbacks.InsightReportOnError.class)
    @PUT
    public InsightReport createReport(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4, @BinderParam(value=BindToJsonPayload.class) CreateInsightReport var5);

    @Named(value="insights:delete-report")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp8"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteReport(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4);

    @Named(value="insights:delete-annotation")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp11"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}/annotations")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteAnnotation(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4, @Nullable @QueryParam(value="externalId") String var5);

    @Named(value="insights:create-annotations")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp12"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}/annotations")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus createAnnotations(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4, @BinderParam(value=BindToJsonPayload.class) CreateAnnotations var5);

    @Named(value="insights:get-annotations")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp13"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}/annotations")
    @Fallback(value=BitbucketFallbacks.AnnotationsResponseOnError.class)
    @GET
    public AnnotationsResponse getAnnotationsByReport(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4);

    @Named(value="insights:create-annotation")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.4.0/bitbucket-code-insights-rest.html#idp13"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/commits/{commitId}/reports/{key}/annotations/{externalId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @PUT
    public RequestStatus createAnnotation(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3, @PathParam(value="key") String var4, @PathParam(value="externalId") String var5, @BinderParam(value=BindToJsonPayload.class) Annotation var6);
}

