/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.sshkey.AccessKey;
import com.cdancy.bitbucket.rest.domain.sshkey.AccessKeyPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateAccessKey;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/keys/{jclouds.api-version}")
public interface KeysApi {
    @Named(value="keys:list-by-repo")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp9"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/ssh")
    @Fallback(value=BitbucketFallbacks.AccessKeyPageOnError.class)
    @GET
    public AccessKeyPage listByRepo(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="keys:create-for-repo")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp10"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/ssh")
    @Fallback(value=BitbucketFallbacks.AccessKeyOnError.class)
    @POST
    public AccessKey createForRepo(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateAccessKey var3);

    @Named(value="keys:get-for-repo")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp12"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/ssh/{id}")
    @Fallback(value=BitbucketFallbacks.AccessKeyOnError.class)
    @GET
    public AccessKey getForRepo(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="id") long var3);

    @Named(value="keys:delete-from-repo")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp13"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/ssh/{id}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteFromRepo(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="id") long var3);

    @Named(value="keys:list-by-project")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp17"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/ssh")
    @Fallback(value=BitbucketFallbacks.AccessKeyPageOnError.class)
    @GET
    public AccessKeyPage listByProject(@PathParam(value="project") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);

    @Named(value="keys:create-for-project")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp18"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/ssh")
    @Fallback(value=BitbucketFallbacks.AccessKeyOnError.class)
    @POST
    public AccessKey createForProject(@PathParam(value="project") String var1, @BinderParam(value=BindToJsonPayload.class) CreateAccessKey var2);

    @Named(value="keys:get-for-project")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp20"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/ssh/{id}")
    @Fallback(value=BitbucketFallbacks.AccessKeyOnError.class)
    @GET
    public AccessKey getForProject(@PathParam(value="project") String var1, @PathParam(value="id") long var2);

    @Named(value="keys:delete-from-project")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/latest/bitbucket-ssh-rest.html#idp21"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/ssh/{id}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteFromProject(@PathParam(value="project") String var1, @PathParam(value="id") long var2);
}

