/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.comment.Task;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateTask;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/1.0/tasks")
public interface TasksApi {
    @Named(value="tasks:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45319070694864"})
    @Consumes(value={"application/json"})
    @Fallback(value=BitbucketFallbacks.TaskOnError.class)
    @POST
    public Task create(@BinderParam(value=BindToJsonPayload.class) CreateTask var1);

    @Named(value="tasks:update")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.16.0/bitbucket-rest.html#idm8288367088"})
    @Consumes(value={"application/json"})
    @Path(value="/{taskId}")
    @Fallback(value=BitbucketFallbacks.TaskOnError.class)
    @Payload(value="%7B \"state\": \"{state}\" %7D")
    @PUT
    public Task update(@PathParam(value="taskId") int var1, @PayloadParam(value="state") String var2);

    @Named(value="tasks:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45701777641664"})
    @Consumes(value={"application/json"})
    @Path(value="/{taskId}")
    @Fallback(value=BitbucketFallbacks.TaskOnError.class)
    @GET
    public Task get(@PathParam(value="taskId") int var1);

    @Named(value="tasks:delete")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45701777664960"})
    @Consumes(value={"application/json"})
    @Path(value="/{taskId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="taskId") int var1);
}

