/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.handlers;

import com.cdancy.bitbucket.rest.exception.ForbiddenException;
import com.cdancy.bitbucket.rest.exception.MethodNotAllowedException;
import com.cdancy.bitbucket.rest.exception.UnsupportedMediaTypeException;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceAlreadyExistsException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Strings2;

public class BitbucketErrorHandler
implements HttpErrorHandler {
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        Object exception = null;
        try {
            String message = this.parseMessage(command, response);
            switch (response.getStatusCode()) {
                case 400: {
                    exception = new IllegalArgumentException(message);
                    break;
                }
                case 401: {
                    exception = new AuthorizationException(message);
                    break;
                }
                case 403: {
                    exception = new ForbiddenException(message);
                    break;
                }
                case 404: {
                    exception = new ResourceNotFoundException(message);
                    break;
                }
                case 405: {
                    exception = new MethodNotAllowedException(message);
                    break;
                }
                case 409: {
                    exception = new ResourceAlreadyExistsException(message);
                    break;
                }
                case 415: {
                    exception = new UnsupportedMediaTypeException(message);
                    break;
                }
                default: {
                    exception = new HttpResponseException(command, response);
                }
            }
        }
        catch (Exception e) {
            try {
                exception = new HttpResponseException(command, response, (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly((Closeable)response.getPayload());
                command.setException(exception);
                throw throwable;
            }
            Closeables2.closeQuietly((Closeable)response.getPayload());
            command.setException((Exception)exception);
        }
        Closeables2.closeQuietly((Closeable)response.getPayload());
        command.setException((Exception)exception);
    }

    private String parseMessage(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose((InputStream)response.getPayload().openStream());
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return new StringBuffer(command.getCurrentRequest().getRequestLine()).append(" -> ").append(response.getStatusLine()).toString();
    }
}

