/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.InfoList;
import io.github.classgraph.MethodInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

public class MethodInfoList
extends InfoList<MethodInfo> {
    static final MethodInfoList EMPTY_LIST = new MethodInfoList(){

        @Override
        public boolean add(MethodInfo e) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void add(int index, MethodInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public MethodInfo remove(int index) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(Collection<? extends MethodInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends MethodInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public MethodInfo set(int index, MethodInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public Iterator<MethodInfo> iterator() {
            return new Iterator<MethodInfo>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public MethodInfo next() {
                    return null;
                }
            };
        }

        @Override
        public Spliterator<MethodInfo> spliterator() {
            return new Spliterator<MethodInfo>(){

                @Override
                public boolean tryAdvance(Consumer<? super MethodInfo> action) {
                    return false;
                }

                @Override
                public Spliterator<MethodInfo> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return 0L;
                }

                @Override
                public int characteristics() {
                    return 0;
                }
            };
        }

        @Override
        public ListIterator<MethodInfo> listIterator() {
            return new ListIterator<MethodInfo>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public MethodInfo next() {
                    return null;
                }

                @Override
                public boolean hasPrevious() {
                    return false;
                }

                @Override
                public MethodInfo previous() {
                    return null;
                }

                @Override
                public int nextIndex() {
                    return 0;
                }

                @Override
                public int previousIndex() {
                    return 0;
                }

                @Override
                public void remove() {
                    throw new IllegalArgumentException("List is immutable");
                }

                @Override
                public void set(MethodInfo e) {
                    throw new IllegalArgumentException("List is immutable");
                }

                @Override
                public void add(MethodInfo e) {
                    throw new IllegalArgumentException("List is immutable");
                }
            };
        }
    };

    public static MethodInfoList emptyList() {
        return EMPTY_LIST;
    }

    public MethodInfoList() {
    }

    public MethodInfoList(int sizeHint) {
        super(sizeHint);
    }

    public MethodInfoList(Collection<MethodInfo> methodInfoCollection) {
        super(methodInfoCollection);
    }

    void findReferencedClassNames(Set<String> referencedClassNames) {
        for (MethodInfo mi : this) {
            mi.findReferencedClassNames(referencedClassNames);
        }
    }

    public Map<String, MethodInfoList> asMap() {
        HashMap<String, MethodInfoList> methodNameToMethodInfoList = new HashMap<String, MethodInfoList>();
        for (MethodInfo methodInfo : this) {
            String name = methodInfo.getName();
            MethodInfoList methodInfoList = (MethodInfoList)methodNameToMethodInfoList.get(name);
            if (methodInfoList == null) {
                methodInfoList = new MethodInfoList(1);
                methodNameToMethodInfoList.put(name, methodInfoList);
            }
            methodInfoList.add(methodInfo);
        }
        return methodNameToMethodInfoList;
    }

    public boolean containsName(String methodName) {
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public MethodInfoList get(String methodName) {
        boolean hasMethodWithName = false;
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            hasMethodWithName = true;
            break;
        }
        if (!hasMethodWithName) {
            return EMPTY_LIST;
        }
        MethodInfoList matchingMethods = new MethodInfoList(2);
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            matchingMethods.add(mi);
        }
        return matchingMethods;
    }

    public MethodInfo getSingleMethod(String methodName) {
        int numMethodsWithName = 0;
        MethodInfo lastFoundMethod = null;
        for (MethodInfo mi : this) {
            if (!mi.getName().equals(methodName)) continue;
            ++numMethodsWithName;
            lastFoundMethod = mi;
        }
        if (numMethodsWithName == 0) {
            return null;
        }
        if (numMethodsWithName == 1) {
            return lastFoundMethod;
        }
        throw new IllegalArgumentException("There are multiple methods named \"" + methodName + "\" in class " + ((MethodInfo)this.iterator().next()).getName());
    }

    public MethodInfoList filter(MethodInfoFilter filter) {
        MethodInfoList methodInfoFiltered = new MethodInfoList();
        for (MethodInfo resource : this) {
            if (!filter.accept(resource)) continue;
            methodInfoFiltered.add(resource);
        }
        return methodInfoFiltered;
    }

    @FunctionalInterface
    public static interface MethodInfoFilter {
        public boolean accept(MethodInfo var1);
    }
}

