/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.Resource;
import io.github.classgraph.Scanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.MappedByteBufferResources;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;

class ClasspathElementDir
extends ClasspathElement {
    private final File classpathEltDir;
    private final int ignorePrefixLen;
    private final Set<String> scannedCanonicalPaths = new HashSet<String>();
    private final NestedJarHandler nestedJarHandler;

    ClasspathElementDir(File classpathEltDir, ClassLoader classLoader, NestedJarHandler nestedJarHandler, ScanSpec scanSpec) {
        super(classLoader, scanSpec);
        this.classpathEltDir = classpathEltDir;
        this.ignorePrefixLen = classpathEltDir.getPath().length() + 1;
        this.nestedJarHandler = nestedJarHandler;
    }

    @Override
    void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> workQueue, int classpathElementIdx, LogNode log) {
        if (!this.scanSpec.scanDirs) {
            if (log != null) {
                this.log(classpathElementIdx, "Skipping classpath element, since dir scanning is disabled: " + this.classpathEltDir, log);
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            int childClasspathEntryIdx = 0;
            for (String libDirPrefix : ClassLoaderHandlerRegistry.AUTOMATIC_LIB_DIR_PREFIXES) {
                Object[] listFiles;
                File libDir = new File(this.classpathEltDir, libDirPrefix);
                if (!FileUtils.canReadAndIsDir(libDir) || (listFiles = libDir.listFiles()) == null) continue;
                Arrays.sort(listFiles);
                for (Object file : listFiles) {
                    if (!((File)file).isFile() || !((File)file).getName().endsWith(".jar")) continue;
                    if (log != null) {
                        this.log(classpathElementIdx, "Found lib jar: " + file, log);
                    }
                    workQueue.addWorkUnit(new Scanner.ClasspathEntryWorkUnit(new ClasspathOrder.ClasspathElementAndClassLoader(((File)file).getPath(), this.classLoader), this, childClasspathEntryIdx++));
                }
            }
            for (String packageRootPrefix : ClassLoaderHandlerRegistry.AUTOMATIC_PACKAGE_ROOT_PREFIXES) {
                File packageRootDir = new File(this.classpathEltDir, packageRootPrefix);
                if (!FileUtils.canReadAndIsDir(packageRootDir)) continue;
                if (log != null) {
                    this.log(classpathElementIdx, "Found package root: " + packageRootDir, log);
                }
                workQueue.addWorkUnit(new Scanner.ClasspathEntryWorkUnit(new ClasspathOrder.ClasspathElementAndClassLoader(packageRootDir.getPath(), this.classLoader), this, childClasspathEntryIdx++));
            }
        }
        catch (SecurityException e) {
            if (log != null) {
                this.log(classpathElementIdx, "Skipping classpath element, since dir cannot be accessed: " + this.classpathEltDir, log);
            }
            this.skipClasspathElement = true;
            return;
        }
    }

    private Resource newResource(final String relativePath, final File classpathResourceFile, final NestedJarHandler nestedJarHandler) {
        return new Resource(this, classpathResourceFile.length()){
            private MappedByteBufferResources mappedFileResources;

            @Override
            public String getPath() {
                return relativePath;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return relativePath;
            }

            @Override
            public long getLastModified() {
                return classpathResourceFile.lastModified();
            }

            @Override
            public Set<PosixFilePermission> getPosixFilePermissions() {
                Set<PosixFilePermission> posixFilePermissions = null;
                try {
                    posixFilePermissions = Files.readAttributes(classpathResourceFile.toPath(), PosixFileAttributes.class, new LinkOption[0]).permissions();
                }
                catch (IOException | SecurityException | UnsupportedOperationException exception) {
                    // empty catch block
                }
                return posixFilePermissions;
            }

            @Override
            public synchronized ByteBuffer read() throws IOException {
                if (ClasspathElementDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                this.markAsOpen();
                try {
                    this.mappedFileResources = new MappedByteBufferResources(classpathResourceFile, nestedJarHandler);
                    if (this.mappedFileResources.numChunks() > 1) {
                        throw new IOException("File is larger than 2GB -- cannot use read() method, use open() instead");
                    }
                    this.byteBuffer = this.mappedFileResources.getByteBuffer(0);
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (IOException | OutOfMemoryError | SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            synchronized InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                    return new InputStreamOrByteBufferAdapter(this.read());
                }
                this.inputStream = new Resource.InputStreamResourceCloser(this, this, Files.newInputStream(classpathResourceFile.toPath(), new OpenOption[0]));
                return new InputStreamOrByteBufferAdapter(this.inputStream);
            }

            @Override
            public synchronized InputStream open() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD && this.length <= 0x7FFFFFF7L) {
                    this.read();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this, this.byteBufferToInputStream());
                    return this.inputStream;
                }
                this.markAsOpen();
                try {
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this, Files.newInputStream(classpathResourceFile.toPath(), new OpenOption[0]));
                    return this.inputStream;
                }
                catch (IOException | SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public synchronized byte[] load() throws IOException {
                try {
                    byte[] byteArray;
                    if (this.length > 0x7FFFFFF7L) {
                        throw new IOException("File is larger than 2GB, cannot read into array");
                    }
                    if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                        this.read();
                        byteArray = this.byteBufferToByteArray();
                    } else {
                        this.open();
                        byteArray = FileUtils.readAllBytesAsArray(this.inputStream, this.length);
                    }
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public synchronized void close() {
                super.close();
                if (this.mappedFileResources != null) {
                    this.mappedFileResources.close(null);
                    this.mappedFileResources = null;
                }
                this.markAsClosed();
            }
        };
    }

    @Override
    Resource getResource(String relativePath) {
        File resourceFile = new File(this.classpathEltDir, relativePath);
        return FileUtils.canReadAndIsFile(resourceFile) ? this.newResource(relativePath, resourceFile, this.nestedJarHandler) : null;
    }

    private void scanDirRecursively(File dir, LogNode log) {
        LogNode subLog;
        String dirRelativePath;
        String canonicalPath;
        if (this.skipClasspathElement) {
            return;
        }
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!this.scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String string = dirRelativePath = this.ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(this.ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        if (this.nestedClasspathRootPrefixes != null && this.nestedClasspathRootPrefixes.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        if (dirRelativePath.startsWith("META-INF/versions/")) {
            if (log != null) {
                log.log("Found unexpected nested versioned entry in directory classpath element -- skipping: " + dirRelativePath);
            }
            return;
        }
        this.checkResourcePathWhiteBlackList(dirRelativePath, log);
        if (this.skipClasspathElement) {
            return;
        }
        ScanSpec.ScanSpecPathMatch parentMatchStatus = this.scanSpec.dirWhitelistMatchStatus(dirRelativePath);
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached blacklisted directory, stopping recursive scan: " + dirRelativePath);
            }
            return;
        }
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH) {
            return;
        }
        Object[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        Arrays.sort(filesInDir);
        LogNode logNode = log == null ? null : (subLog = log.log("1:" + canonicalPath, "Scanning directory: " + dir + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath)));
        if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) {
            for (Object fileInDir : filesInDir) {
                if (!((File)fileInDir).isFile()) continue;
                String fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? ((File)fileInDir).getName() : dirRelativePath + ((File)fileInDir).getName();
                this.checkResourcePathWhiteBlackList(fileInDirRelativePath, subLog);
                if (this.skipClasspathElement) {
                    return;
                }
                if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.classfileIsSpecificallyWhitelisted(fileInDirRelativePath)) {
                    Resource resource = this.newResource(fileInDirRelativePath, (File)fileInDir, this.nestedJarHandler);
                    this.addWhitelistedResource(resource, parentMatchStatus, false, subLog);
                    this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
                    continue;
                }
                if (subLog == null) continue;
                subLog.log("Skipping non-whitelisted file: " + fileInDirRelativePath);
            }
        } else if (this.scanSpec.enableClassInfo && dirRelativePath.equals("/")) {
            for (Object fileInDir : filesInDir) {
                if (!((File)fileInDir).getName().equals("module-info.class") || !((File)fileInDir).isFile()) continue;
                Resource resource = this.newResource("module-info.class", (File)fileInDir, this.nestedJarHandler);
                this.addWhitelistedResource(resource, parentMatchStatus, true, subLog);
                this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
            }
        }
        for (Object fileInDir : filesInDir) {
            if (!((File)fileInDir).isDirectory()) continue;
            this.scanDirRecursively((File)fileInDir, subLog);
            if (!this.skipClasspathElement) continue;
            if (subLog != null) {
                subLog.addElapsedTime();
            }
            return;
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        this.fileToLastModified.put(dir, dir.lastModified());
    }

    @Override
    void scanPaths(int classpathElementIdx, LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        LogNode subLog = log == null ? null : this.log(classpathElementIdx, "Scanning directory classpath element " + this.classpathEltDir, log);
        this.scanDirRecursively(this.classpathEltDir, subLog);
        this.finishScanPaths(subLog);
    }

    @Override
    public String getModuleName() {
        return this.moduleNameFromModuleDescriptor == null || this.moduleNameFromModuleDescriptor.isEmpty() ? null : this.moduleNameFromModuleDescriptor;
    }

    @Override
    public File getFile() {
        return this.classpathEltDir;
    }

    @Override
    URI getURI() {
        return this.classpathEltDir.toURI();
    }

    public String toString() {
        return this.classpathEltDir.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClasspathElementDir)) {
            return false;
        }
        ClasspathElementDir other = (ClasspathElementDir)obj;
        return this.classpathEltDir.equals(other.classpathEltDir);
    }

    public int hashCode() {
        return this.classpathEltDir.hashCode();
    }
}

